/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.memento;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataOutputStreamExtended;
import org.nakedobjects.metamodel.config.internal.PropertiesConfiguration;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.specloader.NakedObjectReflector;
import org.nakedobjects.runtime.context.NakedObjectsContextStatic;
import org.nakedobjects.runtime.memento.Data;
import org.nakedobjects.runtime.memento.Memento;
import org.nakedobjects.runtime.memento.ObjectData;
import org.nakedobjects.runtime.memento.TestObject;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.session.NakedObjectSession;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;

public class MementoTest2_Test {
    private Mockery mockery = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };
    private NakedObject rootAdapter;
    private NakedObject returnedAdapter;
    private TestObject rootObject;
    private TestObject recreatedObject;
    private Oid oid;
    private Data data;
    private Memento memento;

    @Before
    public void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        final NakedObjectSpecification rootSpecification = (NakedObjectSpecification)this.mockery.mock(NakedObjectSpecification.class);
        final OneToOneAssociation nameField = (OneToOneAssociation)this.mockery.mock(OneToOneAssociation.class);
        final NakedObjectSpecification nameSpecification = (NakedObjectSpecification)this.mockery.mock(NakedObjectSpecification.class, "name specification");
        final EncodableFacet encodeableFacet = (EncodableFacet)this.mockery.mock(EncodableFacet.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectSpecification)this.atLeast(1).of((Object)rootSpecification)).isCollection();
                this.will(2.returnValue((Object)false));
                ((NakedObjectSpecification)this.atLeast(1).of((Object)rootSpecification)).getAssociations();
                this.will(2.returnValue((Object)new NakedObjectAssociation[]{nameField}));
                ((NakedObjectSpecification)this.atLeast(1).of((Object)rootSpecification)).getFullName();
                this.will(2.returnValue((Object)TestObject.class.getName()));
                ((OneToOneAssociation)this.atLeast(1).of((Object)nameField)).isNotDerived();
                this.will(2.returnValue((Object)true));
                ((OneToOneAssociation)this.atLeast(1).of((Object)nameField)).isOneToManyAssociation();
                this.will(2.returnValue((Object)false));
                ((OneToOneAssociation)this.atLeast(1).of((Object)nameField)).getSpecification();
                this.will(2.returnValue((Object)nameSpecification));
                ((OneToOneAssociation)this.atLeast(1).of((Object)nameField)).getId();
                this.will(2.returnValue((Object)"name-field"));
                ((NakedObjectSpecification)this.atLeast(1).of((Object)nameSpecification)).isEncodeable();
                this.will(2.returnValue((Object)true));
                ((NakedObjectSpecification)this.atLeast(1).of((Object)nameSpecification)).getFacet(EncodableFacet.class);
                this.will(2.returnValue((Object)encodeableFacet));
            }
        });
        this.rootAdapter = (NakedObject)this.mockery.mock(NakedObject.class);
        this.rootObject = new TestObject("Harry");
        final NakedObject nameAdapter = (NakedObject)this.mockery.mock(NakedObject.class, "name");
        this.oid = (Oid)this.mockery.mock(Oid.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObject)this.atLeast(1).of((Object)MementoTest2_Test.this.rootAdapter)).getSpecification();
                this.will(3.returnValue((Object)rootSpecification));
                ((NakedObject)this.atLeast(1).of((Object)MementoTest2_Test.this.rootAdapter)).getOid();
                this.will(3.returnValue((Object)MementoTest2_Test.this.oid));
                ((NakedObject)this.atLeast(1).of((Object)MementoTest2_Test.this.rootAdapter)).getResolveState();
                this.will(3.returnValue((Object)ResolveState.RESOLVED));
                ((OneToOneAssociation)this.atLeast(1).of((Object)nameField)).get(MementoTest2_Test.this.rootAdapter);
                this.will(3.returnValue((Object)nameAdapter));
                ((EncodableFacet)this.one(encodeableFacet)).toEncodedString(nameAdapter);
                this.will(3.returnValue((Object)"_HARRY_"));
            }
        });
        this.mockery.checking((ExpectationBuilder)new Expectations(){});
        NakedObjectReflector reflector = (NakedObjectReflector)this.mockery.mock(NakedObjectReflector.class);
        PersistenceSession mockPersistenceSession = (PersistenceSession)this.mockery.mock(PersistenceSession.class);
        NakedObjectSessionFactory sessionFactory = (NakedObjectSessionFactory)this.mockery.mock(NakedObjectSessionFactory.class);
        AuthenticationSession mockSession = (AuthenticationSession)this.mockery.mock(AuthenticationSession.class);
        NakedObjectSession session = (NakedObjectSession)this.mockery.mock(NakedObjectSession.class);
        NakedObjectsContextStatic.createRelaxedInstance((NakedObjectSessionFactory)sessionFactory);
        this.memento = new Memento(this.rootAdapter);
        this.data = this.memento.getData();
    }

    @Test
    public void testOid() throws Exception {
        Assert.assertEquals((Object)this.oid, (Object)this.data.getOid());
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testResolved() throws Exception {
        Assert.assertEquals((Object)"Resolved", (Object)this.data.getResolveState());
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testClassName() throws Exception {
        Assert.assertEquals((Object)TestObject.class.getName(), (Object)this.data.getClassName());
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testStringField() throws Exception {
        Assert.assertEquals(ObjectData.class, this.data.getClass());
        Assert.assertEquals((Object)"_HARRY_", (Object)((ObjectData)this.data).getEntry("name-field"));
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testEncode() throws Exception {
        final DataOutputStreamExtended mockOutputImpl = (DataOutputStreamExtended)this.mockery.mock(DataOutputStreamExtended.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((DataOutputStreamExtended)this.one(mockOutputImpl)).writeEncodable(this.with(5.any(ObjectData.class)));
            }
        });
        this.memento.encodedData(mockOutputImpl);
        this.mockery.assertIsSatisfied();
    }
}

