/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.runtime.persistence.adapterfactory.pojo.PojoAdapter;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.PersistAlgorithm;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;

public abstract class PersistAlgorithmContractTest
extends ProxyJunit3TestCase {
    private PersistedObjectAdderSpy adder;
    private PersistAlgorithm persistAlgorithm;

    public void setUp() throws Exception {
        super.setUp();
        this.adder = new PersistedObjectAdderSpy();
        this.persistAlgorithm = this.createPersistAlgorithm();
    }

    protected abstract PersistAlgorithm createPersistAlgorithm();

    public void testMakePersistentSkipsAggregatedObjects() {
        PojoAdapter aggregatedObject = new PojoAdapter(new Object(), (Oid)SerialOid.createTransient((long)1L));
        aggregatedObject.changeState(ResolveState.VALUE);
        this.persistAlgorithm.makePersistent((NakedObject)aggregatedObject, (ToPersistObjectSet)this.adder);
        PersistAlgorithmContractTest.assertEquals((int)0, (int)this.adder.getPersistedObjects().size());
    }

    static interface PersistAlgorithmSensing
    extends PersistAlgorithm {
        public void persist(NakedObject var1, ToPersistObjectSet var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class PersistedObjectAdderSpy
    implements ToPersistObjectSet {
        private final List<NakedObject> persistedObjects = new ArrayList<NakedObject>();

        protected PersistedObjectAdderSpy() {
        }

        public List<NakedObject> getPersistedObjects() {
            return this.persistedObjects;
        }

        public void addPersistedObject(NakedObject object) {
            this.persistedObjects.add(object);
        }

        public void remapAsPersistent(NakedObject object) {
            object.changeState(ResolveState.RESOLVED);
        }
    }
}

