/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore.transaction;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStoreSpy;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStoreTransactionManagement;
import org.nakedobjects.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransaction;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.testsystem.TestProxySystem;
import org.nakedobjects.runtime.transaction.NakedObjectTransaction;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;
import org.nakedobjects.runtime.transaction.PersistenceCommand;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

@RunWith(value=JMock.class)
public class TransactionTest {
    private Mockery mockery = new JUnit4Mockery();
    private NakedObject object1;
    private NakedObject object2;
    private ObjectStoreSpy os;
    private ObjectStoreTransaction t;
    private NakedObjectTransactionManager mockTransactionManager;
    private MessageBroker mockMessageBroker;
    private UpdateNotifier mockUpdateNotifier;

    private CreateObjectCommand createCreateCommand(final NakedObject object, final String name) {
        return new CreateObjectCommand(){

            public void execute(NakedObjectTransaction context) throws ObjectPersistenceException {
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return name;
            }
        };
    }

    private DestroyObjectCommand createDestroyCommand(final NakedObject object, final String name) {
        return new DestroyObjectCommand(){

            public void execute(NakedObjectTransaction context) throws ObjectPersistenceException {
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return name;
            }
        };
    }

    private SaveObjectCommand createSaveCommand(final NakedObject object, final String name) {
        return new SaveObjectCommand(){

            public void execute(NakedObjectTransaction context) throws ObjectPersistenceException {
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return name;
            }
        };
    }

    private SaveObjectCommand createCommandThatAborts(final NakedObject object, final String name) {
        return new SaveObjectCommand(){

            public void execute(NakedObjectTransaction context) throws ObjectPersistenceException {
                throw new ObjectPersistenceException();
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return name;
            }
        };
    }

    @Before
    public void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        TestProxySystem system = new TestProxySystem();
        system.init();
        this.mockTransactionManager = (NakedObjectTransactionManager)this.mockery.mock(NakedObjectTransactionManager.class);
        this.mockMessageBroker = (MessageBroker)this.mockery.mock(MessageBroker.class);
        this.mockUpdateNotifier = (UpdateNotifier)this.mockery.mock(UpdateNotifier.class);
        this.os = new ObjectStoreSpy();
        this.t = new ObjectStoreTransaction(this.mockTransactionManager, this.mockMessageBroker, this.mockUpdateNotifier, (ObjectStoreTransactionManagement)this.os);
        this.object1 = system.createTransientTestObject();
        this.object2 = system.createTransientTestObject();
    }

    @Test
    public void testAbort() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "command 1"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object2, "command 2"));
        this.t.abort();
        Assert.assertEquals((long)0L, (long)this.os.getActions().size());
    }

    @Test
    public void testAbortBeforeCommand() throws Exception {
        this.t.abort();
        Assert.assertEquals((long)0L, (long)this.os.getActions().size());
    }

    @Test
    public void testCommandThrowsAnExceptionCausingAbort() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "command 1"));
        this.t.addCommand((PersistenceCommand)this.createCommandThatAborts(this.object2, "command 2"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "command 3"));
        try {
            this.t.commit();
            Assert.fail();
        }
        catch (ObjectPersistenceException objectPersistenceException) {
            // empty catch block
        }
        this.os.assertAction(0, "execute command 1");
        this.os.assertAction(1, "execute command 2");
    }

    @Test
    public void testAddCommands() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "command 1"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object2, "command 2"));
        this.t.commit();
        this.os.assertAction(0, "execute command 1");
        this.os.assertAction(1, "execute command 2");
        Assert.assertEquals((long)2L, (long)this.os.getActions().size());
    }

    @Test
    public void testAddCreateCommandsButIgnoreSaveForSameObject() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createCreateCommand(this.object1, "create object 1"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "save object 1"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object2, "save object 2"));
        this.t.commit();
        this.os.assertAction(0, "execute create object 1");
        this.os.assertAction(1, "execute save object 2");
        Assert.assertEquals((long)2L, (long)this.os.getActions().size());
    }

    @Test
    public void testAddDestoryCommandsButRemovePreviousSaveForSameObject() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "save object 1"));
        this.t.addCommand((PersistenceCommand)this.createDestroyCommand(this.object1, "destroy object 1"));
        this.t.commit();
        this.os.assertAction(0, "execute destroy object 1");
        Assert.assertEquals((long)1L, (long)this.os.getActions().size());
    }

    @Test
    public void testIgnoreBothCreateAndDestroyCommandsWhenForSameObject() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createCreateCommand(this.object1, "create object 1"));
        this.t.addCommand((PersistenceCommand)this.createDestroyCommand(this.object1, "destroy object 1"));
        this.t.addCommand((PersistenceCommand)this.createDestroyCommand(this.object2, "destroy object 2"));
        this.t.commit();
        this.os.assertAction(0, "execute destroy object 2");
        Assert.assertEquals((long)1L, (long)this.os.getActions().size());
    }

    @Test
    public void testIgnoreSaveAfterDeleteForSameObject() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createDestroyCommand(this.object1, "destroy object 1"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "save object 1"));
        this.t.commit();
        this.os.assertAction(0, "execute destroy object 1");
        Assert.assertEquals((long)1L, (long)this.os.getActions().size());
    }

    @Test
    public void testNoCommands() throws Exception {
        this.t.commit();
        Assert.assertEquals((long)0L, (long)this.os.getActions().size());
    }

    @Test
    public void createandThenDestroyShouldCancelEachOtherOut() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createCreateCommand(this.object1, "create object 1"));
        this.t.addCommand((PersistenceCommand)this.createDestroyCommand(this.object1, "destroy object 1"));
        this.t.commit();
        Assert.assertEquals((long)0L, (long)this.os.getActions().size());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionIfAttemptToAbortAnAlreadyAbortedTransaction() throws Exception {
        this.t.abort();
        this.t.abort();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionIfAttemptToCommitAnAlreadyAbortedTransaction() throws Exception {
        this.t.abort();
        this.t.commit();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionIfAttemptToAbortAnAlreadyCommitedTransaction() throws Exception {
        this.t.commit();
        this.t.abort();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionIfAttemptToCommitAnAlreadyCommitedTransaction() throws Exception {
        this.t.commit();
        this.t.commit();
    }
}

