/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.nakedobjects.metamodel.commons.lang.MethodUtils;
import org.nakedobjects.metamodel.facets.MethodScope;
import org.nakedobjects.metamodel.specloader.internal.introspector.MethodFinderUtils;

@RunWith(value=Parameterized.class)
public class MethodFinderUtilsTest {
    private static Method staticMethod = MethodUtils.findMethodElseNull(MethodFinderUtilsTest.class, (String)"someStaticMethod", (Class[])new Class[0]);
    private static Method instanceMethod = MethodUtils.findMethodElseNull(MethodFinderUtilsTest.class, (String)"someInstanceMethod", (Class[])new Class[0]);
    private final MethodScope methodScope;
    private final Method method;
    private final boolean result;

    @Before
    public void setUp() {
        Assert.assertThat((Object)staticMethod, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)instanceMethod, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({MethodScope.OBJECT, staticMethod, false}, {MethodScope.CLASS, staticMethod, true}, {MethodScope.OBJECT, instanceMethod, true}, {MethodScope.CLASS, instanceMethod, false});
    }

    public static void someStaticMethod() {
    }

    public void someInstanceMethod() {
    }

    public MethodFinderUtilsTest(MethodScope methodScope, Method method, boolean result) {
        this.methodScope = methodScope;
        this.method = method;
        this.result = result;
    }

    @Test
    public void all() {
        Assert.assertThat((Object)MethodFinderUtils.inScope((MethodScope)this.methodScope, (Method)this.method), (Matcher)CoreMatchers.is((Object)this.result));
    }
}

