/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system;

import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacetAbstract;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacet;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacetAbstract;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.internal.NakedObjectActionImpl;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectActionPeer;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyNakedObject;
import org.nakedobjects.runtime.testsystem.TestSpecification;

@RunWith(value=JMock.class)
public class NakedObjectActionImplTest
extends ProxyJunit3TestCase {
    private final Mockery mockery = new JUnit4Mockery();
    private NakedObjectActionImpl action;
    private NakedObjectActionPeer mockNakedObjectActionPeer;
    private RuntimeContext mockRuntimeContext;

    public static void main(String[] args) {
        TestRunner.run((junit.framework.Test)new TestSuite(NakedObjectActionImplTest.class));
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mockNakedObjectActionPeer = (NakedObjectActionPeer)this.mockery.mock(NakedObjectActionPeer.class);
        this.mockRuntimeContext = (RuntimeContext)this.mockery.mock(RuntimeContext.class);
        this.action = new NakedObjectActionImpl("reduceheadcount", this.mockNakedObjectActionPeer, this.mockRuntimeContext);
    }

    @Test
    public void testExecutePassedOnToPeer() {
        TestProxyNakedObject target = new TestProxyNakedObject();
        target.setupSpecification(new TestSpecification());
        NakedObject[] parameters = new NakedObject[2];
        final TestProxyNakedObject result = new TestProxyNakedObject();
        ActionInvocationFacetAbstract facet = new ActionInvocationFacetAbstract((FacetHolder)this.mockNakedObjectActionPeer){

            public NakedObject invoke(NakedObject target, NakedObject[] parameters) {
                return result;
            }

            public NakedObjectSpecification getReturnType() {
                return null;
            }

            public NakedObjectSpecification getOnType() {
                return new TestSpecification();
            }
        };
        this.mockery.checking((ExpectationBuilder)new Expectations((ActionInvocationFacet)facet){
            final /* synthetic */ ActionInvocationFacet val$facet;
            {
                this.val$facet = actionInvocationFacet;
                ((NakedObjectActionPeer)this.exactly(2).of((Object)NakedObjectActionImplTest.this.mockNakedObjectActionPeer)).getFacet(ActionInvocationFacet.class);
                this.will(2.returnValue((Object)this.val$facet));
            }
        });
        NakedObject returnObject = this.action.execute((NakedObject)target, parameters);
        NakedObjectActionImplTest.assertEquals((Object)returnObject, (Object)result);
    }

    @Test
    public void testNameDefaultsToActionsMethodName() {
        NamedFacetAbstract facet = new NamedFacetAbstract("Reduceheadcount", (FacetHolder)this.mockNakedObjectActionPeer){};
        this.mockery.checking((ExpectationBuilder)new Expectations((NamedFacet)facet){
            final /* synthetic */ NamedFacet val$facet;
            {
                this.val$facet = namedFacet;
                ((NakedObjectActionPeer)this.one(NakedObjectActionImplTest.this.mockNakedObjectActionPeer)).getFacet(NamedFacet.class);
                this.will(4.returnValue((Object)this.val$facet));
            }
        });
        NakedObjectActionImplTest.assertEquals((String)"Reduceheadcount", (String)this.action.getName());
    }

    @Test
    public void testId() {
        NakedObjectActionImplTest.assertEquals((String)"reduceheadcount", (String)this.action.getId());
    }
}

