/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system.specpeer;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.nakedobjects.runtime.system.specpeer.ExpectedSet;

public class ExpectedSetTest
extends TestCase {
    private ExpectedSet set;

    public static void main(String[] args) {
        TestRunner.run(ExpectedSetTest.class);
    }

    protected void setUp() throws Exception {
        this.set = new ExpectedSet();
        this.set.addExpected("test");
        this.set.addExpected("expected");
        this.set.addExpected("list");
    }

    public void testAddActuals() {
        this.set.addActual("test");
        this.set.addActual("expected");
        this.set.addActual("list");
        this.set.verify();
    }

    public void testAddActualsInWrongOrder() {
        try {
            this.set.addActual("test");
            this.set.addActual("list");
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedSetTest.fail();
    }

    public void testAddInvalidActuals() {
        try {
            this.set.addActual("not");
            this.set.addActual("part");
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedSetTest.fail();
    }

    public void testAddTooFewActuals() {
        try {
            this.set.addActual("test");
            this.set.addActual("expected");
            this.set.verify();
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedSetTest.fail();
    }

    public void testAddTooManyActuals() {
        try {
            this.set.addActual("test");
            this.set.addActual("expected");
            this.set.addActual("list");
            this.set.addActual("overrun");
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedSetTest.fail();
    }

    public void testNoActuals() {
        try {
            this.set.verify();
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedSetTest.fail();
    }

    public void testNoExpectedNoActuals() {
        this.set = new ExpectedSet();
        this.set.verify();
    }
}

