/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.testsystem;

import java.util.Hashtable;
import java.util.Vector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.applib.DomainObjectContainer;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.services.ServicesInjectorDefault;
import org.nakedobjects.metamodel.services.container.DomainObjectContainerDefault;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSessionAbstract;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactoryAbstract;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerDefault;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.internal.RuntimeContextFromSession;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactoryAbstract;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactoryBasic;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.testsystem.TestProxyException;
import org.nakedobjects.runtime.testsystem.TestProxyNakedObject;
import org.nakedobjects.runtime.testsystem.TestProxyOidGenerator;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionDefault;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManagerAbstract;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

public class TestProxyPersistenceSession
extends PersistenceSessionAbstract {
    private final NakedObjectTransactionManager transactionManager = new NakedObjectTransactionManagerAbstract<NakedObjectTransactionDefault>(){

        public void startTransaction() {
            TestProxyPersistenceSession.this.actions.addElement("start transaction");
            this.createTransaction();
        }

        protected NakedObjectTransactionDefault createTransaction(MessageBroker messageBroker, UpdateNotifier updateNotifier) {
            return new NakedObjectTransactionDefault((NakedObjectTransactionManager)this, messageBroker, updateNotifier);
        }

        public boolean flushTransaction() {
            TestProxyPersistenceSession.this.actions.addElement("flush transaction");
            return false;
        }

        public void abortTransaction() {
            ((NakedObjectTransactionDefault)this.getTransaction()).abort();
        }

        public void endTransaction() {
            TestProxyPersistenceSession.this.actions.addElement("end transaction");
            ((NakedObjectTransactionDefault)this.getTransaction()).commit();
        }
    };
    private final Vector<String> actions = new Vector();
    private final Hashtable<Oid, NakedObject> persistedObjects = new Hashtable();

    public TestProxyPersistenceSession(PersistenceSessionFactory persistenceSessionFactory) {
        super(persistenceSessionFactory, (AdapterFactory)new AdapterFactoryTestProxyNakedObject(), (ObjectFactory)new ObjectFactoryBasic(ObjectFactoryAbstract.Mode.RELAXED){}, (ServicesInjector)new ServicesInjectorDefault(), (OidGenerator)new TestProxyOidGenerator(), (AdapterManagerExtended)new AdapterManagerDefault());
        RuntimeContextFromSession runtimeContext = new RuntimeContextFromSession();
        DomainObjectContainerDefault container = new DomainObjectContainerDefault();
        runtimeContext.injectInto((Object)container);
        runtimeContext.setContainer((DomainObjectContainer)container);
        this.getServicesInjector().setContainer((DomainObjectContainer)container);
        this.setTransactionManager(this.transactionManager);
    }

    public void doOpen() {
        this.getAdapterFactory().injectInto((Object)this.getAdapterManager());
        this.getSpecificationLoader().injectInto((Object)this.getAdapterManager());
        this.getOidGenerator().injectInto((Object)this.getAdapterManager());
    }

    public NakedObject loadObject(Oid oid, NakedObjectSpecification spec) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)spec, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        NakedObject adapter = this.getAdapterManager().getAdapterFor(oid);
        if (adapter == null) {
            adapter = this.persistedObjects.get(oid);
        }
        if (adapter == null) {
            throw new TestProxyException("No persisted object to get for " + oid);
        }
        return adapter;
    }

    public void makePersistent(NakedObject object) {
        this.getAdapterManager().remapAsPersistent(object);
        object.setOptimisticLock((Version)new TestProxyVersion(1));
    }

    public void objectChanged(NakedObject object) {
        this.actions.addElement("object changed " + object.getOid());
        object.setOptimisticLock(((TestProxyVersion)object.getVersion()).next());
    }

    public void destroyObject(NakedObject object) {
        this.actions.addElement("object deleted " + object.getOid());
    }

    public void testReset() {
        this.getAdapterManager().reset();
    }

    public void resolveImmediately(NakedObject object) {
        throw new NotYetImplementedException();
    }

    public void resolveField(NakedObject object, NakedObjectAssociation association) {
        this.actions.addElement("object deleted " + object.getOid());
    }

    protected NakedObject[] getInstances(PersistenceQuery criteria) {
        throw new NotYetImplementedException();
    }

    protected Oid getOidForService(String name) {
        throw new NotYetImplementedException();
    }

    protected void registerService(String name, Oid oid) {
        throw new NotYetImplementedException();
    }

    public void reload(NakedObject adapter) {
        throw new NotYetImplementedException();
    }

    public boolean isFixturesInstalled() {
        throw new NotYetImplementedException();
    }

    public boolean hasInstances(NakedObjectSpecification specification) {
        throw new NotYetImplementedException();
    }

    public String debugTitle() {
        return null;
    }

    protected static class AdapterFactoryTestProxyNakedObject
    extends AdapterFactoryAbstract {
        protected AdapterFactoryTestProxyNakedObject() {
        }

        public TestProxyNakedObject createAdapter(Object pojo, Oid oid) {
            TestProxyNakedObject testProxyNakedObject = new TestProxyNakedObject();
            testProxyNakedObject.setupObject(pojo);
            testProxyNakedObject.setupOid(oid);
            testProxyNakedObject.setupResolveState(oid == null ? ResolveState.VALUE : (oid.isTransient() ? ResolveState.TRANSIENT : ResolveState.GHOST));
            testProxyNakedObject.setupSpecification(NakedObjectsContext.getSpecificationLoader().loadSpecification(pojo.getClass()));
            return testProxyNakedObject;
        }
    }
}

