/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.StringUtils;
import org.nakedobjects.metamodel.commons.threads.ThreadRunner;
import org.nakedobjects.metamodel.config.ConfigurationBuilder;
import org.nakedobjects.metamodel.config.ConfigurationBuilderDefault;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.installers.InstallerLookupDefault;
import org.nakedobjects.runtime.logging.NakedObjectsLoggingConfigurer;
import org.nakedobjects.runtime.options.BootPrinter;
import org.nakedobjects.runtime.options.OptionHandler;
import org.nakedobjects.runtime.options.standard.OptionHandlerAdditionalProperty;
import org.nakedobjects.runtime.options.standard.OptionHandlerConfiguration;
import org.nakedobjects.runtime.options.standard.OptionHandlerConnector;
import org.nakedobjects.runtime.options.standard.OptionHandlerDebug;
import org.nakedobjects.runtime.options.standard.OptionHandlerDeploymentType;
import org.nakedobjects.runtime.options.standard.OptionHandlerDiagnostics;
import org.nakedobjects.runtime.options.standard.OptionHandlerFixture;
import org.nakedobjects.runtime.options.standard.OptionHandlerHelp;
import org.nakedobjects.runtime.options.standard.OptionHandlerNoSplash;
import org.nakedobjects.runtime.options.standard.OptionHandlerPassword;
import org.nakedobjects.runtime.options.standard.OptionHandlerPersistor;
import org.nakedobjects.runtime.options.standard.OptionHandlerQuiet;
import org.nakedobjects.runtime.options.standard.OptionHandlerReflector;
import org.nakedobjects.runtime.options.standard.OptionHandlerUser;
import org.nakedobjects.runtime.options.standard.OptionHandlerUserProfileStore;
import org.nakedobjects.runtime.options.standard.OptionHandlerVerbose;
import org.nakedobjects.runtime.options.standard.OptionHandlerVersion;
import org.nakedobjects.runtime.options.standard.OptionHandlerViewer;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.NakedObjectsSystemBootstrapper;
import org.nakedobjects.runtime.viewer.NakedObjectsViewer;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerInstaller;
import org.nakedobjects.runtime.web.EmbeddedWebServer;
import org.nakedobjects.runtime.web.EmbeddedWebServerInstaller;
import org.nakedobjects.runtime.web.WebAppSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NakedObjects {
    private static final String DEFAULT_EMBEDDED_WEBSERVER = "jetty";
    private List<OptionHandler> optionHandlers = new ArrayList<OptionHandler>();
    private OptionHandlerDeploymentType flagHandlerDeploymentType;
    private OptionHandlerConnector flagHandlerClientConnection;
    private OptionHandlerPersistor flagHandlerPersistor;
    private OptionHandlerUser flagHandlerUser;
    private OptionHandlerPassword flagHandlerPassword;
    private OptionHandlerViewer flagHandlerViewer;

    public static void main(String[] args) {
        new NakedObjects().run(args);
    }

    public void run(String[] args) {
        this.setupLoggingImmediately(args);
        InstallerLookupDefault installerLookup = new InstallerLookupDefault(NakedObjects.class);
        this.addOptionHandlers(installerLookup);
        Options options = new Options();
        for (OptionHandler optionHandler : this.optionHandlers) {
            optionHandler.addOption(options);
        }
        BootPrinter printer = new BootPrinter();
        BasicParser parser = new BasicParser();
        try {
            CommandLine commandLine = parser.parse(options, args);
            for (OptionHandler optionHandler : this.optionHandlers) {
                if (optionHandler.handle(commandLine, printer, options)) continue;
                return;
            }
        }
        catch (ParseException e) {
            printer.printErrorMessage(e.getMessage());
            printer.printHelp(options);
            return;
        }
        DeploymentType deploymentType = this.flagHandlerDeploymentType.getDeploymentType();
        List<String> viewerNames = this.flagHandlerViewer.getViewerNames();
        List<String> connectorNames = this.flagHandlerClientConnection.getConnectorNames();
        String objectPersistorName = this.flagHandlerPersistor.getPersistorName();
        String user = this.flagHandlerUser.getUserName();
        String password = this.flagHandlerPassword.getPassword();
        if (!this.validateDeploymentTypeAndConnectors(options, printer, deploymentType, connectorNames)) {
            return;
        }
        if (!this.validateDeploymentTypeAndViewers(options, printer, deploymentType, viewerNames)) {
            return;
        }
        if (!this.validateDeploymentTypeAndPersistor(options, printer, deploymentType, objectPersistorName)) {
            return;
        }
        if (!this.validateUserAndPasswordCombo(options, printer, user, password)) {
            // empty if block
        }
        ConfigurationBuilderDefault builder = this.createConfigurationBuilder();
        for (OptionHandler optionHandler : this.optionHandlers) {
            optionHandler.primeConfigurationBuilder((ConfigurationBuilder)builder);
        }
        builder.injectInto((Object)installerLookup);
        installerLookup.init();
        this.bootstrapSystemAndViewers(installerLookup, deploymentType, viewerNames);
    }

    public List<OptionHandler> getFlagHandlers() {
        return Collections.unmodifiableList(this.optionHandlers);
    }

    protected void addOptionHandlers(InstallerLookup installerLookup) {
        this.addOptionHandler(new OptionHandlerConfiguration());
        this.flagHandlerClientConnection = new OptionHandlerConnector(installerLookup);
        this.addOptionHandler(this.flagHandlerClientConnection);
        this.flagHandlerDeploymentType = this.createOptionHandlerDeploymentType();
        this.addOptionHandler(this.flagHandlerDeploymentType);
        this.flagHandlerPersistor = new OptionHandlerPersistor(installerLookup);
        this.addOptionHandler(this.flagHandlerPersistor);
        this.addOptionHandler(new OptionHandlerReflector(installerLookup));
        this.flagHandlerViewer = new OptionHandlerViewer(installerLookup);
        this.addOptionHandler(this.flagHandlerViewer);
        this.flagHandlerUser = new OptionHandlerUser();
        this.addOptionHandler(this.flagHandlerUser);
        this.flagHandlerPassword = new OptionHandlerPassword();
        this.addOptionHandler(this.flagHandlerPassword);
        this.addOptionHandler(new OptionHandlerUserProfileStore(installerLookup));
        this.addOptionHandler(new OptionHandlerFixture());
        this.addOptionHandler(new OptionHandlerNoSplash());
        this.addOptionHandler(new OptionHandlerAdditionalProperty());
        this.addOptionHandler(new OptionHandlerDebug());
        this.addOptionHandler(new OptionHandlerDiagnostics());
        this.addOptionHandler(new OptionHandlerQuiet());
        this.addOptionHandler(new OptionHandlerVerbose());
        this.addOptionHandler(new OptionHandlerHelp());
        this.addOptionHandler(new OptionHandlerVersion());
    }

    protected OptionHandlerDeploymentType createOptionHandlerDeploymentType() {
        return new OptionHandlerDeploymentType();
    }

    protected boolean addOptionHandler(OptionHandler optionHandler) {
        return this.optionHandlers.add(optionHandler);
    }

    private boolean validateUserAndPasswordCombo(Options options, BootPrinter printer, String user, String password) {
        if (password == null && user == null) {
            return true;
        }
        printer.printErrorAndHelp(options, "A user name must be specified with a password", new Object[0]);
        return false;
    }

    private boolean validateDeploymentTypeAndPersistor(Options options, BootPrinter printer, DeploymentType deploymentType, String objectPersistor) {
        if (deploymentType.canSpecifyObjectStore() || StringUtils.isEmpty((String)objectPersistor)) {
            return true;
        }
        printer.printErrorAndHelp(options, "Error: cannot specify an object store (persistor) for deployment type %s\n", deploymentType.name().toLowerCase());
        return false;
    }

    private boolean validateDeploymentTypeAndViewers(Options options, BootPrinter printer, DeploymentType deploymentType, List<String> viewers) {
        if (deploymentType.canSpecifyViewers(viewers)) {
            return true;
        }
        printer.printErrorAndHelp(options, "Error: cannot specify %s viewer%s for deployment type %s\n", viewers.size() > 1 ? "more than one" : "any", viewers.size() > 1 ? "" : "s", deploymentType.name().toLowerCase());
        return false;
    }

    private boolean validateDeploymentTypeAndConnectors(Options options, BootPrinter printer, DeploymentType deploymentType, List<String> connectors) {
        if (deploymentType.canSpecifyConnectors(connectors)) {
            return true;
        }
        printer.printErrorAndHelp(options, "Error: cannot specify %s connector%s for deployment type %s\n", connectors.size() > 1 ? "more than one" : "any", connectors.size() > 1 ? "" : "s", deploymentType.name().toLowerCase());
        return false;
    }

    private void setupLoggingImmediately(String[] args) {
        new NakedObjectsLoggingConfigurer().configureLogging(args);
    }

    protected ConfigurationBuilderDefault createConfigurationBuilder() {
        return new ConfigurationBuilderDefault();
    }

    protected void bootstrapSystemAndViewers(InstallerLookup installerLookup, DeploymentType deploymentType, List<String> viewerNames) {
        List<NakedObjectsViewer> viewers = this.lookupViewers(installerLookup, viewerNames, deploymentType);
        this.bootstrapSystem(installerLookup, deploymentType);
        List<NakedObjectsViewer> webViewers = this.findWebViewers(viewers);
        List<NakedObjectsViewer> nonWebViewers = this.findNonWebViewers(viewers, webViewers);
        this.startNonWebViewers(nonWebViewers);
        this.startWebViewers(installerLookup, webViewers);
    }

    private List<NakedObjectsViewer> lookupViewers(InstallerLookup installerLookup, List<String> viewerNames, DeploymentType deploymentType) {
        ArrayList<String> requestedViewers = new ArrayList<String>(viewerNames);
        deploymentType.addViewersIfAnyTo(requestedViewers);
        ArrayList<NakedObjectsViewer> viewers = new ArrayList<NakedObjectsViewer>();
        for (String requestedViewer : requestedViewers) {
            String defaultViewer;
            NakedObjectsViewerInstaller viewerInstaller = installerLookup.viewerInstaller(requestedViewer, defaultViewer = deploymentType.getDefaultViewer());
            if (viewerInstaller == null) {
                throw new NakedObjectException("Can't find viewer: " + requestedViewer);
            }
            NakedObjectsViewer viewer = viewerInstaller.createViewer();
            viewers.add(viewer);
        }
        return viewers;
    }

    private void bootstrapSystem(InstallerLookup installerLookup, DeploymentType deploymentType) {
        NakedObjectsSystemBootstrapper bootstrapper = new NakedObjectsSystemBootstrapper(installerLookup);
        bootstrapper.bootSystem(deploymentType);
    }

    private List<NakedObjectsViewer> findWebViewers(List<NakedObjectsViewer> viewers) {
        ArrayList<NakedObjectsViewer> webViewers = new ArrayList<NakedObjectsViewer>(viewers);
        CollectionUtils.filter(webViewers, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                NakedObjectsViewer viewer = (NakedObjectsViewer)object;
                return viewer.getWebAppSpecification() != null;
            }
        });
        return webViewers;
    }

    private List<NakedObjectsViewer> findNonWebViewers(List<NakedObjectsViewer> viewers, List<NakedObjectsViewer> webViewers) {
        ArrayList<NakedObjectsViewer> nonWebViewers = new ArrayList<NakedObjectsViewer>(viewers);
        nonWebViewers.removeAll(webViewers);
        return nonWebViewers;
    }

    private void startNonWebViewers(List<NakedObjectsViewer> viewers) {
        for (final NakedObjectsViewer viewer : viewers) {
            Runnable target = new Runnable(){

                public void run() {
                    viewer.init();
                }
            };
            new ThreadRunner().startThread(target, "Viewer");
        }
    }

    private void startWebViewers(InstallerLookup installerLookup, List<NakedObjectsViewer> webViewers) {
        if (webViewers.size() == 0) {
            return;
        }
        EmbeddedWebServerInstaller webServerInstaller = installerLookup.embeddedWebServerInstaller(DEFAULT_EMBEDDED_WEBSERVER);
        EmbeddedWebServer embeddedWebServer = webServerInstaller.createEmbeddedWebServer();
        for (NakedObjectsViewer viewer : webViewers) {
            WebAppSpecification webContainerRequirements = viewer.getWebAppSpecification();
            embeddedWebServer.addWebAppSpecification(webContainerRequirements);
        }
        embeddedWebServer.init();
    }
}

