/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.NoAuthenticatorException;
import org.nakedobjects.runtime.authentication.standard.Authenticator;
import org.nakedobjects.runtime.authentication.standard.RandomCodeGenerator;
import org.nakedobjects.runtime.authentication.standard.RandomCodeGenerator10Chars;
import org.nakedobjects.runtime.authentication.standard.exploration.ExplorationAuthenticator;
import org.nakedobjects.runtime.authentication.standard.fixture.LogonFixtureAuthenticator;
import org.nakedobjects.runtime.authentication.standard.singleuser.SingleUserAuthenticator;
import org.nakedobjects.runtime.context.NakedObjectsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationManagerStandard
implements AuthenticationManager,
DebugInfo {
    private List<Authenticator> authenticators = new ArrayList<Authenticator>();
    private final Map<String, String> userByValidationCode = new HashMap<String, String>();
    private RandomCodeGenerator randomCodeGenerator;
    private NakedObjectConfiguration configuration;

    public AuthenticationManagerStandard(NakedObjectConfiguration configuration) {
        this.configuration = configuration;
    }

    public final void init() {
        this.defaultRandomCodeGeneratorIfNecessary();
        this.addDefaultAuthenticators();
        if (this.authenticators.size() == 0) {
            throw new NakedObjectException("No authenticators specified");
        }
        for (Authenticator authenticator : this.authenticators) {
            authenticator.init();
        }
    }

    private void defaultRandomCodeGeneratorIfNecessary() {
        if (this.randomCodeGenerator == null) {
            this.randomCodeGenerator = new RandomCodeGenerator10Chars();
        }
    }

    private void addDefaultAuthenticators() {
        this.addAuthenticatorToStart(new ExplorationAuthenticator(this.getConfiguration()));
        this.addAuthenticatorToStart(new SingleUserAuthenticator(this.getConfiguration()));
        this.addAuthenticatorToStart(new LogonFixtureAuthenticator(this.getConfiguration()));
    }

    public void shutdown() {
        for (Authenticator authenticator : this.authenticators) {
            authenticator.shutdown();
        }
    }

    @Override
    public final synchronized AuthenticationSession authenticate(AuthenticationRequest request) {
        if (request == null) {
            return null;
        }
        for (Authenticator authenticator : this.authenticators) {
            if (!authenticator.canAuthenticate(request)) continue;
            AuthenticationSession authSession = null;
            authSession = authenticator.authenticate(request, this.getUnusedRandomCode());
            if (authSession != null) {
                this.userByValidationCode.put(authSession.getValidationCode(), authSession.getUserName());
            }
            return authSession;
        }
        throw new NoAuthenticatorException("No authenticator available for processing " + request.getClass().getName());
    }

    private String getUnusedRandomCode() {
        String code;
        while (this.userByValidationCode.containsKey(code = this.randomCodeGenerator.generateRandomCode())) {
        }
        return code;
    }

    @Override
    public final boolean isSessionValid(AuthenticationSession session) {
        String userName = this.userByValidationCode.get(session.getValidationCode());
        return session.hasUserNameOf(userName);
    }

    @Override
    public void closeSession(AuthenticationSession session) {
        this.userByValidationCode.remove(session.getValidationCode());
        NakedObjectsContext.closeSession();
    }

    public final void addAuthenticator(Authenticator authenticator) {
        this.authenticators.add(authenticator);
    }

    private void addAuthenticatorToStart(Authenticator authenticator) {
        this.authenticators.add(0, authenticator);
    }

    public void setAuthenticators(List<Authenticator> authenticators) {
        this.authenticators = authenticators;
    }

    public List<Authenticator> getAuthenticators() {
        return Collections.unmodifiableList(this.authenticators);
    }

    public RandomCodeGenerator getRandomCodeGenerator() {
        return this.randomCodeGenerator;
    }

    public void setRandomCodeGenerator(RandomCodeGenerator randomCodeGenerator) {
        Ensure.ensureThatArg((Object)randomCodeGenerator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"randomCodeGenerator cannot be null");
        this.randomCodeGenerator = randomCodeGenerator;
    }

    public String debugTitle() {
        return "Authentication Manager";
    }

    public void debugData(DebugString debug) {
        debug.appendTitle("Authenticators");
        debug.indent();
        for (Authenticator authenticator : this.authenticators) {
            debug.appendln(authenticator.toString());
        }
        debug.unindent();
        debug.appendTitle("Users");
        debug.indent();
        for (String userName : this.userByValidationCode.values()) {
            debug.appendln(userName);
        }
        debug.unindent();
    }

    public String toString() {
        ToString str = ToString.createAnonymous((Object)this);
        str.append("authenticators", this.authenticators.size());
        str.append("users", this.userByValidationCode.size());
        return str.toString();
    }

    protected NakedObjectConfiguration getConfiguration() {
        return this.configuration;
    }
}

