/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard.exploration;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.standard.AuthenticatorAbstract;
import org.nakedobjects.runtime.authentication.standard.SimpleSession;
import org.nakedobjects.runtime.authentication.standard.exploration.AuthenticationRequestExploration;
import org.nakedobjects.runtime.authentication.standard.exploration.ExplorationSession;
import org.nakedobjects.runtime.authentication.standard.exploration.MultiUserExplorationSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplorationAuthenticator
extends AuthenticatorAbstract {
    private final Set<SimpleSession> registeredSessions = new LinkedHashSet<SimpleSession>();
    private final String users = this.getConfiguration().getString("nakedobjects.exploration.users");

    public ExplorationAuthenticator(NakedObjectConfiguration configuration) {
        super(configuration);
        if (this.users != null) {
            this.registeredSessions.addAll(this.parseUsers(this.users));
        }
    }

    private List<SimpleSession> parseUsers(String users) {
        ArrayList<SimpleSession> registeredUsers = new ArrayList<SimpleSession>();
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            String userName;
            String token = st.nextToken();
            int end = token.indexOf(58);
            ArrayList<String> roles = new ArrayList<String>();
            if (end == -1) {
                userName = token.trim();
            } else {
                userName = token.substring(0, end).trim();
                String roleList = token.substring(end + 1);
                StringTokenizer st2 = new StringTokenizer(roleList, "|");
                while (st2.hasMoreTokens()) {
                    String role = st2.nextToken().trim();
                    roles.add(role);
                }
            }
            registeredUsers.add(this.createSimpleSession(userName, roles));
        }
        return registeredUsers;
    }

    private SimpleSession createSimpleSession(String userName, List<String> roles) {
        return new SimpleSession(userName, roles.toArray(new String[roles.size()]));
    }

    @Override
    public final boolean canAuthenticate(AuthenticationRequest request) {
        return request instanceof AuthenticationRequestExploration;
    }

    @Override
    public final boolean isValid(AuthenticationRequest request) {
        return this.getDeploymentType().isExploring();
    }

    @Override
    public AuthenticationSession authenticate(AuthenticationRequest request, String code) {
        AuthenticationRequestExploration authenticationRequestExploration = (AuthenticationRequestExploration)request;
        if (!authenticationRequestExploration.isDefaultUser()) {
            this.registeredSessions.add(this.createSimpleSession(authenticationRequestExploration.getName(), authenticationRequestExploration.getRoles()));
        }
        if (this.registeredSessions.size() > 1) {
            return new MultiUserExplorationSession(this.registeredSessions, code);
        }
        if (this.registeredSessions.size() == 1) {
            return (AuthenticationSession)this.registeredSessions.iterator().next();
        }
        return new ExplorationSession(code);
    }

    private void addToRegisteredSessions(AuthenticationRequestExploration request) {
    }
}

