/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.IoUtils;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSource;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestPassword;
import org.nakedobjects.runtime.authentication.standard.PasswordRequestAuthenticatorAbstract;

public class FileAuthenticator
extends PasswordRequestAuthenticatorAbstract {
    private final ResourceStreamSource resourceStreamSource;

    public FileAuthenticator(NakedObjectConfiguration configuration) {
        super(configuration);
        this.resourceStreamSource = configuration.getResourceStreamSource();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isValid(AuthenticationRequest request) {
        BufferedReader reader;
        block8: {
            boolean bl;
            block7: {
                AuthenticationRequestPassword passwordRequest = (AuthenticationRequestPassword)request;
                String username = passwordRequest.getName();
                if (username == null) return false;
                if (username.equals("")) {
                    return false;
                }
                String password = passwordRequest.getPassword();
                Assert.assertNotNull((Object)password);
                reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(this.resourceStreamSource.readResource("passwords")));
                    while ((line = reader.readLine()) != null) {
                        if (this.commentedOutOrEmpty(line)) continue;
                        if (line.indexOf(58) == -1) {
                            throw new NakedObjectException("Invalid entry in password file - no colon (:) found on line: " + line);
                        }
                        String name = line.substring(0, line.indexOf(58));
                        if (!name.equals(username)) continue;
                        bl = this.isPasswordValidForUser(request, password, line);
                        break block7;
                    }
                    break block8;
                }
                catch (IOException e) {
                    try {
                        throw new NakedObjectException("Failed to open or read password file: passwords from " + this.resourceStreamSource.getName());
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeSafely(reader);
                        throw throwable;
                    }
                }
            }
            IoUtils.closeSafely((BufferedReader)reader);
            return bl;
        }
        IoUtils.closeSafely((BufferedReader)reader);
        return false;
    }

    private boolean commentedOutOrEmpty(String line) {
        return line.startsWith("#") || line.trim().length() == 0;
    }

    private boolean isPasswordValidForUser(AuthenticationRequest request, String password, String line) {
        int posPasswordStart;
        int posFirstColon = line.indexOf(58);
        int posSecondColonIfAny = line.indexOf(58, posPasswordStart = posFirstColon + 1);
        int posPasswordEnd = posSecondColonIfAny == -1 ? line.length() : posSecondColonIfAny;
        String parsedPassword = line.substring(posPasswordStart, posPasswordEnd);
        if (parsedPassword.equals(password)) {
            if (posSecondColonIfAny != -1) {
                this.setRoles(request, line.substring(posSecondColonIfAny + 1));
            }
            return true;
        }
        return false;
    }

    private final void setRoles(AuthenticationRequest request, String line) {
        StringTokenizer tokens = new StringTokenizer(line, "|", false);
        String[] roles = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            roles[i] = tokens.nextToken();
            ++i;
        }
        request.setRoles(Arrays.asList(roles));
    }
}

