/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authorization.standard.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSource;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.spec.identifier.IdentifierFactory;
import org.nakedobjects.runtime.authorization.standard.AuthorizorAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAuthorizor
extends AuthorizorAbstract {
    private static final Logger LOG = Logger.getLogger(FileAuthorizor.class);
    private static final String NONE = "";
    private static final String RO = "-ro";
    private static final String RW = "-rw";
    private final Map<String, List<String>> whiteListMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> blackListMap = new HashMap<String, List<String>>();
    private final ResourceStreamSource resourceStreamSource = this.getConfiguration().getResourceStreamSource();
    private final boolean learn;
    private final String whiteListResourceName = this.getConfiguration().getString("nakedobjects.authorization.file.whitelist", "allow");
    private final InputStream whiteListInputResource;
    private final String blackListResourceName;
    private final InputStream blackListInputResource;
    private boolean printedWarning;
    private boolean printedDebug;

    public FileAuthorizor(NakedObjectConfiguration configuration) {
        super(configuration);
        Assert.assertTrue((this.whiteListResourceName.length() > 0 ? 1 : 0) != 0);
        this.whiteListInputResource = this.resourceStreamSource.readResource(this.whiteListResourceName);
        this.learn = this.getConfiguration().getBoolean("nakedobjects.authorization.learn", false);
        if (this.whiteListInputResource == null) {
            throw new NakedObjectException("Cannot read whitelist authorization file: " + this.whiteListResourceName);
        }
        this.blackListResourceName = this.getConfiguration().getString("nakedobjects.authorization.file.blacklist", NONE);
        if (this.blackListResourceName.length() > 0) {
            this.blackListInputResource = this.resourceStreamSource.readResource(this.blackListResourceName);
            if (this.blackListInputResource == null) {
                throw new NakedObjectException("Cannot read blacklist authorization file: " + this.blackListResourceName);
            }
        } else {
            this.blackListInputResource = null;
        }
    }

    public void init() {
        if (this.learn) {
            return;
        }
        this.cacheAuthorizationDetails(this.whiteListMap, this.whiteListInputResource);
        if (this.blackListInputResource != null) {
            this.cacheAuthorizationDetails(this.blackListMap, this.blackListInputResource);
        }
    }

    private void cacheAuthorizationDetails(Map<String, List<String>> map, InputStream inputStream) {
        try {
            String line;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("loading authorization details from " + this.whiteListResourceName));
            }
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = buffReader.readLine()) != null) {
                this.tokenizeLine(map, line);
            }
            buffReader.close();
        }
        catch (Exception e) {
            throw new NakedObjectException((Throwable)e);
        }
    }

    private void tokenizeLine(Map<String, List<String>> map, String line) {
        StringTokenizer tokens = new StringTokenizer(line, ":", false);
        Assert.assertTrue((tokens.countTokens() == 2 ? 1 : 0) != 0);
        String token1 = tokens.nextToken();
        String token2 = tokens.nextToken();
        Identifier identifier = this.memberFromString(token1.trim());
        List<String> roles = this.tokenizeRoles(token2);
        String identityString = identifier.toIdentityString(Identifier.CLASS_MEMBERNAME_PARMS);
        map.put(identityString, roles);
    }

    private Identifier memberFromString(String identifier) {
        return IdentifierFactory.fromIdentityString((String)identifier);
    }

    private List<String> tokenizeRoles(String allRoles) {
        ArrayList<String> roles = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(allRoles, "|", false);
        while (tokens.hasMoreTokens()) {
            String nextToken = tokens.nextToken();
            String trimmedNextToken = nextToken.trim();
            roles.add(trimmedNextToken);
        }
        return roles;
    }

    public void shutdown() {
        if (this.learn) {
            this.writeMap();
        }
    }

    @Override
    public boolean isUsableInRole(String role, Identifier member) {
        return this.isAuthorized(role, member, new String[]{NONE, RW});
    }

    @Override
    public boolean isVisibleInRole(String role, Identifier member) {
        return this.isAuthorized(role, member, new String[]{NONE, RO, RW});
    }

    private boolean isAuthorized(String role, Identifier member, String[] qualifiers) {
        if (this.learn) {
            return this.learn(role, member);
        }
        return this.isWhiteListed(role, member, qualifiers) && !this.isBlackListed(role, member, qualifiers);
    }

    private boolean isWhiteListed(String role, Identifier member, String[] qualifiers) {
        return this.isListed(this.whiteListMap, role, member, qualifiers);
    }

    private boolean isBlackListed(String role, Identifier member, String[] qualifiers) {
        return this.isListed(this.blackListMap, role, member, qualifiers);
    }

    private boolean isListed(Map<String, List<String>> map, String role, Identifier identifier, String[] qualifiers) {
        if (map.isEmpty()) {
            return false;
        }
        if (this.isQualifiedMatch(map, role, identifier.toIdentityString(Identifier.CLASS), qualifiers)) {
            return true;
        }
        if (this.isQualifiedMatch(map, role, identifier.toIdentityString(Identifier.CLASS_MEMBERNAME), qualifiers)) {
            return true;
        }
        return this.isQualifiedMatch(map, role, identifier.toIdentityString(Identifier.CLASS_MEMBERNAME_PARMS), qualifiers);
    }

    private boolean isQualifiedMatch(Map<String, List<String>> map, String role, String key, String[] qualifiers) {
        if (map.containsKey(key)) {
            List<String> roles = map.get(key);
            for (int i = 0; i < qualifiers.length; ++i) {
                String qualifiedRole = role + qualifiers[i];
                if (!roles.contains(qualifiedRole)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean learn(String role, Identifier member) {
        String identityString = member.toIdentityString(Identifier.CLASS_MEMBERNAME_PARMS);
        if (this.whiteListMap.containsKey(identityString)) {
            List<String> roles = this.whiteListMap.get(identityString);
            if (!roles.contains(role)) {
                roles.add(role);
            }
        } else {
            this.whiteListMap.put(identityString, Arrays.asList(role));
        }
        this.writeMap();
        return true;
    }

    private void writeMap() {
        try {
            OutputStream whiteListOutputResource = this.resourceStreamSource.writeResource(this.whiteListResourceName);
            if (whiteListOutputResource == null && !this.printedWarning) {
                LOG.warn((Object)"unable to write out authorisation details");
                this.printedWarning = true;
                return;
            }
            if (LOG.isDebugEnabled() && !this.printedDebug) {
                LOG.debug((Object)("writing authorisation details to " + this.whiteListResourceName));
                this.printedDebug = true;
            }
            OutputStreamWriter fileWriter = new OutputStreamWriter(whiteListOutputResource);
            BufferedWriter buffWriter = new BufferedWriter(fileWriter);
            Set<Map.Entry<String, List<String>>> entrySet = this.whiteListMap.entrySet();
            for (int i = 0; i < entrySet.size(); ++i) {
                Map.Entry entry = (Map.Entry)entrySet.toArray()[i];
                StringBuffer buff = new StringBuffer();
                buff.append((String)entry.getKey()).append(":");
                List roles = (List)entry.getValue();
                for (int j = 0; j < roles.size(); ++j) {
                    buff.append((String)roles.get(j));
                    if (j >= roles.size() - 1) continue;
                    buff.append("|");
                }
                buffWriter.write(buff.toString());
                buffWriter.newLine();
            }
            buffWriter.flush();
            buffWriter.close();
        }
        catch (IOException e) {
            throw new NakedObjectException((Throwable)e);
        }
    }
}

