/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authorization.standard.ldap;

import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authorization.standard.AuthorizorAbstract;

public class LdapAuthorizor
extends AuthorizorAbstract {
    private static final Logger LOG = Logger.getLogger(LdapAuthorizor.class);
    private static final String FILTER = "(&(uniquemember={0}) (|(cn={1}) (cn={2}) (cn={3})))";
    private static final String RW = "RW";
    private final String ldapProvider = this.getConfiguration().getString("nakedobjects.authorization.ldap.server");
    private final String ldapDn = this.getConfiguration().getString("nakedobjects.authorization.ldap.dn");
    private final String appDn = this.getConfiguration().getString("nakedobjects.authorization.ldap.application.dn");
    private final boolean learn = this.getConfiguration().getBoolean("nakedobjects.authorization.learn", false);

    public LdapAuthorizor(NakedObjectConfiguration configuration) {
        super(configuration);
    }

    public void init() {
    }

    public void shutdown() {
    }

    public boolean isUsableInRole(String role, Identifier member) {
        return this.isAuthorised(role, member, RW);
    }

    public boolean isVisibleInRole(String role, Identifier member) {
        return this.isAuthorised(role, member, null);
    }

    private boolean isAuthorised(String role, Identifier member, String flag) {
        Hashtable<String, String> env = new Hashtable<String, String>(4);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapProvider);
        if (this.learn) {
            env.put("java.naming.security.principal", "uid=admin, ou=system");
            env.put("java.naming.security.credentials", "secret");
        }
        InitialDirContext authContext = null;
        try {
            authContext = new InitialDirContext(env);
            if (this.learn) {
                boolean bl = this.bindNames(authContext, role, member);
                return bl;
            }
            boolean bl = this.isPermitted(authContext, role, member, flag);
            return bl;
        }
        catch (AuthenticationException e) {
            throw new NakedObjectException("Failed to authorise using LDAP", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            LOG.error((Object)e);
            boolean bl = false;
            return bl;
        }
        catch (NamingException e) {
            throw new NakedObjectException("Failed to authorise using LDAP", (Throwable)e);
        }
        finally {
            try {
                if (authContext != null) {
                    authContext.close();
                }
            }
            catch (NamingException e) {
                throw new NakedObjectException("Failed to authorise using LDAP", (Throwable)e);
            }
        }
    }

    private boolean isPermitted(DirContext authContext, String role, Identifier member, String flag) throws NamingException {
        String cls = member.toIdentityString(Identifier.CLASS);
        String name = member.toIdentityString(Identifier.MEMBERNAME_ONLY);
        String parms = member.toIdentityString(Identifier.PARMS_ONLY);
        Object[] args = new Object[]{role, cls, name, parms};
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        String searchName = this.buildSearchName(cls, this.appDn);
        NamingEnumeration<SearchResult> answer = authContext.search(searchName, FILTER, args, controls);
        while (answer.hasMore()) {
            Attribute flagAttribute;
            SearchResult result = (SearchResult)answer.nextElement();
            String cn = (String)result.getAttributes().get("cn").get(0);
            if (!cn.equals(cls) && !cn.equals(name) && (!cn.equals(parms) || !result.getName().contains(name))) continue;
            if (flag != null && (flagAttribute = result.getAttributes().get("flag")) != null) {
                return flag.equalsIgnoreCase((String)flagAttribute.get(0));
            }
            return true;
        }
        return false;
    }

    private String buildSearchName(String cls, String appDn) {
        StringBuffer search = new StringBuffer();
        search.append("cn=").append(cls).append(", ").append(appDn);
        String searchName = search.toString();
        return searchName;
    }

    private Attributes createCommonAttributes(String cnName, String role, boolean isClass) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("javaContainer");
        objclass.add("groupOfUniqueNames");
        if (isClass) {
            objclass.add("javaObject");
        }
        BasicAttribute cn = new BasicAttribute("cn");
        cn.add(cnName);
        BasicAttribute uniqueMember = new BasicAttribute("uniquemember");
        uniqueMember.add(role);
        if (isClass) {
            BasicAttribute javaClass = new BasicAttribute("javaclassname");
            javaClass.add(cnName);
            attrs.put(javaClass);
        }
        attrs.put(objclass);
        attrs.put(cn);
        attrs.put(uniqueMember);
        return attrs;
    }

    private String createClassBindname(String cls) {
        StringBuffer bindName = new StringBuffer();
        bindName.append("cn=").append(cls).append(", ").append(this.appDn);
        return bindName.toString();
    }

    private void bindClass(DirContext authContext, String role, Identifier member) throws NamingException {
        String cls = member.toIdentityString(Identifier.CLASS);
        Attributes attrs = this.createCommonAttributes(cls, role, true);
        try {
            authContext.createSubcontext(this.createClassBindname(cls), attrs);
        }
        catch (NameAlreadyBoundException e) {
            LOG.debug((Object)e);
        }
    }

    private String createNameBindname(String cls, String name) {
        StringBuffer bindName = new StringBuffer();
        bindName.append("cn=").append(name).append(", ");
        bindName.append(this.createClassBindname(cls));
        return bindName.toString();
    }

    private void bindName(DirContext authContext, String role, Identifier member) throws NamingException {
        String cls = member.toIdentityString(Identifier.CLASS);
        String name = member.toIdentityString(Identifier.MEMBERNAME_ONLY);
        Attributes attrs = this.createCommonAttributes(name, role, false);
        try {
            authContext.createSubcontext(this.createNameBindname(cls, name), attrs);
        }
        catch (NameAlreadyBoundException e) {
            LOG.debug((Object)e);
        }
    }

    private String createParmsBindname(String cls, String name, String parms) {
        StringBuffer bindName = new StringBuffer();
        bindName.append("cn=").append(parms).append(", ");
        bindName.append(this.createNameBindname(cls, name));
        return bindName.toString();
    }

    private void bindParms(DirContext authContext, String role, Identifier member) throws NamingException {
        String cls = member.toIdentityString(Identifier.CLASS);
        String name = member.toIdentityString(Identifier.MEMBERNAME_ONLY);
        String parms = member.toIdentityString(Identifier.PARMS_ONLY).replace(",", "\\,");
        if (parms.length() == 0) {
            return;
        }
        Attributes attrs = this.createCommonAttributes(parms, role, false);
        try {
            authContext.createSubcontext(this.createParmsBindname(cls, name, parms), attrs);
        }
        catch (NameAlreadyBoundException e) {
            LOG.debug((Object)e);
        }
    }

    private boolean bindNames(DirContext authContext, String role, Identifier member) throws NamingException {
        this.bindClass(authContext, role, member);
        this.bindName(authContext, role, member);
        this.bindParms(authContext, role, member);
        return true;
    }
}

