/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.bytecode;

import java.lang.reflect.Method;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.java5.ImperativeFacet;
import org.nakedobjects.metamodel.spec.JavaSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectChanger;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectResolveAndObjectChangedEnhancerAbstract {
    protected final ObjectResolver objectResolver;
    protected final ObjectChanger objectChanger;
    protected final SpecificationLoader specificationLoader;

    public ObjectResolveAndObjectChangedEnhancerAbstract(ObjectResolver objectResolver, ObjectChanger objectChanger, SpecificationLoader specificationLoader) {
        Ensure.ensureThatArg((Object)objectResolver, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)objectChanger, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)specificationLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.objectResolver = objectResolver;
        this.objectChanger = objectChanger;
        this.specificationLoader = specificationLoader;
    }

    protected abstract void createCallback();

    protected JavaSpecification getJavaSpecificationOfOwningClass(Method method) {
        return this.getJavaSpecification(method.getDeclaringClass());
    }

    protected JavaSpecification getJavaSpecification(Class<?> cls) {
        NakedObjectSpecification nos = this.getSpecification(cls);
        if (!(nos instanceof JavaSpecification)) {
            throw new UnsupportedOperationException("Only Java is supported (specification is '" + nos.getClass().getCanonicalName() + "')");
        }
        return (JavaSpecification)nos;
    }

    protected boolean impliesResolve(ImperativeFacet[] imperativeFacets) {
        for (ImperativeFacet imperativeFacet : imperativeFacets) {
            if (!imperativeFacet.impliesResolve()) continue;
            return true;
        }
        return false;
    }

    protected boolean impliesObjectChanged(ImperativeFacet[] imperativeFacets) {
        for (ImperativeFacet imperativeFacet : imperativeFacets) {
            if (!imperativeFacet.impliesObjectChanged()) continue;
            return true;
        }
        return false;
    }

    private NakedObjectSpecification getSpecification(Class<?> type) {
        return this.specificationLoader.loadSpecification(type);
    }

    public final ObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public final ObjectChanger getObjectChanger() {
        return this.objectChanger;
    }

    public final SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }
}

