/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.context.NakedObjectsContextMultiUser;
import org.nakedobjects.runtime.session.NakedObjectSession;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;

public class NakedObjectsContextThreadLocal
extends NakedObjectsContextMultiUser {
    private static final Logger LOG = Logger.getLogger(NakedObjectsContextThreadLocal.class);
    private final Map<Thread, NakedObjectSession> sessionsByThread = new HashMap<Thread, NakedObjectSession>();

    public static NakedObjectsContext createInstance(NakedObjectSessionFactory sessionFactory) {
        return new NakedObjectsContextThreadLocal(sessionFactory);
    }

    protected NakedObjectsContextThreadLocal(NakedObjectSessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void closeAllSessionsInstance() {
        this.shutdownAllThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownAllThreads() {
        Map<Thread, NakedObjectSession> map = this.sessionsByThread;
        synchronized (map) {
            int i = 0;
            for (Thread thread : this.sessionsByThread.keySet()) {
                LOG.info((Object)("Shutting down thread: " + i++));
                NakedObjectSession data = this.sessionsByThread.get(thread);
                data.closeAll();
            }
        }
    }

    protected void doClose() {
        this.sessionsByThread.remove(Thread.currentThread());
    }

    public String[] allSessionIds() {
        String[] ids = new String[this.sessionsByThread.size()];
        int i = 0;
        for (Thread thread : this.sessionsByThread.keySet()) {
            NakedObjectSession data = this.sessionsByThread.get(thread);
            ids[i++] = data.getId();
        }
        return ids;
    }

    public String debugTitle() {
        return "Naked Objects (by thread) " + Thread.currentThread().getName();
    }

    public void debugData(DebugString debug) {
        super.debugData(debug);
        debug.appendln();
        debug.appendTitle("Threads based Contexts");
        for (Thread thread : this.sessionsByThread.keySet()) {
            NakedObjectSession data = this.sessionsByThread.get(thread);
            debug.appendln(thread.toString(), (Object)data);
        }
    }

    protected NakedObjectSession getSessionInstance(String executionContextId) {
        for (Thread thread : this.sessionsByThread.keySet()) {
            NakedObjectSession data = this.sessionsByThread.get(thread);
            if (!data.getId().equals(executionContextId)) continue;
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NakedObjectSession openSessionInstance(AuthenticationSession authenticationSession) {
        Thread thread = Thread.currentThread();
        Map<Thread, NakedObjectSession> map = this.sessionsByThread;
        synchronized (map) {
            this.applySessionClosePolicy();
            NakedObjectSession session = this.getSessionFactoryInstance().openSession(authenticationSession);
            LOG.info((Object)("  opening session " + session + " (count " + this.sessionsByThread.size() + ") for " + authenticationSession.getUserName()));
            this.saveSession(thread, session);
            session.open();
            return session;
        }
    }

    protected NakedObjectSession createAndOpenSession(Thread thread, AuthenticationSession authenticationSession) {
        NakedObjectSession session = this.getSessionFactoryInstance().openSession(authenticationSession);
        session.open();
        LOG.info((Object)("  opening session " + session + " (count " + this.sessionsByThread.size() + ") for " + authenticationSession.getUserName()));
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NakedObjectSession saveSession(Thread thread, NakedObjectSession session) {
        Map<Thread, NakedObjectSession> map = this.sessionsByThread;
        synchronized (map) {
            this.sessionsByThread.put(thread, session);
        }
        LOG.info((Object)("  saving session " + session + "; now have " + this.sessionsByThread.size() + " sessions"));
        return session;
    }

    public NakedObjectSession getSessionInstance() {
        Thread thread = Thread.currentThread();
        NakedObjectSession session = this.sessionsByThread.get(thread);
        return session;
    }
}

