/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.fixturesinstaller.config;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.runtime.fixturesinstaller.FixturesInstallerAbstract;
import org.nakedobjects.runtime.fixturesinstaller.FixturesInstallerDelegate;

public class FixturesFromConfiguration
extends FixturesInstallerAbstract {
    private static final Logger LOG = Logger.getLogger(FixturesFromConfiguration.class);
    private static final String NAKEDOBJECTS_FIXTURES = "nakedobjects.fixtures";
    private static final String NAKEDOBJECTS_FIXTURES_PREFIX = "nakedobjects.fixtures.prefix";

    public FixturesFromConfiguration() {
        super("configuration");
    }

    protected void addFixturesTo(FixturesInstallerDelegate delegate) {
        String fixturePrefix = this.getConfiguration().getString(NAKEDOBJECTS_FIXTURES_PREFIX);
        String string = fixturePrefix = fixturePrefix == null ? "" : fixturePrefix.trim();
        if (fixturePrefix.length() > 0 && !fixturePrefix.endsWith(".")) {
            fixturePrefix = fixturePrefix + ".";
        }
        try {
            String[] fixtureList = this.getConfiguration().getList(NAKEDOBJECTS_FIXTURES);
            boolean fixtureLoaded = false;
            for (int i = 0; i < fixtureList.length; ++i) {
                String fixtureFullyQualifiedName = fixturePrefix + fixtureList[i];
                LOG.info((Object)("  adding fixture " + fixtureFullyQualifiedName));
                Object fixture = InstanceFactory.createInstance((String)fixtureFullyQualifiedName);
                fixtureLoaded = true;
                delegate.addFixture(fixture);
            }
            if (!fixtureLoaded) {
                LOG.warn((Object)"No fixtures loaded from configuration");
            }
        }
        catch (IllegalArgumentException e) {
            throw new NakedObjectException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new NakedObjectException((Throwable)e);
        }
    }
}

