/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.help.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.help.HelpManagerAbstract;

public class FileBasedHelpManager
extends HelpManagerAbstract {
    private static final Logger LOG = Logger.getLogger(FileBasedHelpManager.class);
    public static final String DEFAULT_FILE_NAME = "help.txt";
    private static final String CLASS_PREFIX = "c:";
    private static final String NAME_PREFIX = "m:";
    private String fileName = "help.txt";
    private final NakedObjectConfiguration configuration;

    public FileBasedHelpManager(NakedObjectConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String help(Identifier identifier) {
        String string;
        BufferedReader reader = null;
        try {
            String line;
            boolean lookingForName;
            reader = this.getReader();
            if (reader == null) {
                String string2 = "No help available (no file found)";
                return string2;
            }
            String className = CLASS_PREFIX + identifier.getClassName().toLowerCase();
            String name = NAME_PREFIX + identifier.getMemberName().toLowerCase();
            StringBuffer str = new StringBuffer();
            boolean lookingForClass = true;
            boolean bl = lookingForName = identifier.getMemberName().length() > 0;
            while ((line = reader.readLine()) != null) {
                if (line.length() > 0 && line.charAt(0) == '#') continue;
                if (line.toLowerCase().equals(className)) {
                    lookingForClass = false;
                    continue;
                }
                if (lookingForClass) continue;
                if (line.toLowerCase().startsWith(CLASS_PREFIX)) break;
                if (line.toLowerCase().equals(name)) {
                    lookingForName = false;
                    continue;
                }
                if (lookingForName) continue;
                if (line.toLowerCase().startsWith(NAME_PREFIX)) break;
                str.append(line);
                str.append('\n');
            }
            string = str.toString();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"opening help file", (Throwable)e);
            String string3 = "Failure opening help file: " + e.getMessage();
            return string3;
        }
        catch (IOException e) {
            LOG.error((Object)"reading help file", (Throwable)e);
            String string4 = "Failure reading help file: " + e.getMessage();
            return string4;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
        return string;
    }

    protected BufferedReader getReader() throws FileNotFoundException {
        File file = new File(this.fileName);
        if (!file.exists()) {
            String message = "No help file found: " + file.getAbsolutePath();
            LOG.warn((Object)message);
            return null;
        }
        return new BufferedReader(new FileReader(file));
    }
}

