/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.imageloader;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import org.apache.log4j.Logger;
import org.nakedobjects.runtime.imageloader.TemplateImage;

public class TemplateImageImpl
implements TemplateImage {
    private static final Logger LOG = Logger.getLogger(TemplateImageImpl.class);
    private final Image image;
    private final MediaTracker mt = new MediaTracker(new Canvas());

    public static TemplateImageImpl create(Image image) {
        if (image == null) {
            return null;
        }
        return new TemplateImageImpl(image);
    }

    private TemplateImageImpl(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getIcon(int height) {
        if (height == this.image.getHeight(null)) {
            return this.image;
        }
        Image iconImage = this.image.getScaledInstance(-1, height, 4);
        if (iconImage != null) {
            this.mt.addImage(iconImage, 0);
            try {
                this.mt.waitForAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mt.isErrorAny()) {
                LOG.error((Object)("failed to create scaled image: " + iconImage + " " + this.mt.getErrorsAny()[0]));
                this.mt.removeImage(iconImage);
                iconImage = null;
            } else {
                this.mt.removeImage(iconImage);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("image " + iconImage + " scaled to " + height));
                }
            }
        }
        if (iconImage == null || iconImage.getWidth(null) == -1) {
            throw new RuntimeException("scaled image! " + iconImage.toString());
        }
        return iconImage;
    }
}

