/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.installers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nakedobjects.metamodel.commons.component.Installer;
import org.nakedobjects.metamodel.config.ConfigurationBuilder;
import org.nakedobjects.metamodel.config.ConfigurationBuilderAware;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstallerAbstract
implements Installer,
ConfigurationBuilderAware {
    private final String type;
    private final String name;
    private ConfigurationBuilder configurationBuilder;
    private NakedObjectConfiguration configuration;

    public InstallerAbstract(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getConfigurationResources() {
        ArrayList<String> resourceList = new ArrayList<String>();
        String componentFile = this.getType() + ".properties";
        resourceList.add(componentFile);
        String componentImplementationFile = this.getType() + "_" + this.getName() + ".properties";
        resourceList.add(componentImplementationFile);
        this.addConfigurationResources(resourceList);
        return Collections.unmodifiableList(resourceList);
    }

    protected void addConfigurationResources(List<String> configurationResources) {
    }

    public void init() {
    }

    public void shutdown() {
    }

    public void setConfigurationBuilder(ConfigurationBuilder configurationBuilder) {
        if (this.configuration != null) {
            throw new IllegalStateException("A NakedObjectConfiguration has already been provided.");
        }
        this.configurationBuilder = configurationBuilder;
    }

    public void setConfiguration(NakedObjectConfiguration configuration) {
        if (this.configurationBuilder != null) {
            throw new IllegalStateException("A NakedObjectConfiguration has already been provided.");
        }
        this.configuration = configuration;
    }

    public NakedObjectConfiguration getConfiguration() {
        if (this.configurationBuilder != null) {
            return this.configurationBuilder.getConfiguration();
        }
        if (this.configuration != null) {
            return this.configuration;
        }
        throw new IllegalStateException("Neither a ConfigurationBuilder nor Configuration has not been provided");
    }
}

