/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.installers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.commons.component.Installer;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.factory.InstanceCreationException;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.metamodel.commons.factory.UnavailableClassException;
import org.nakedobjects.metamodel.commons.lang.CastUtils;
import org.nakedobjects.metamodel.config.ConfigurationBuilder;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.NotFoundPolicy;
import org.nakedobjects.metamodel.specloader.NakedObjectReflectorInstaller;
import org.nakedobjects.runtime.authentication.AuthenticationManagerInstaller;
import org.nakedobjects.runtime.authentication.standard.noop.NoopAuthenticationManagerInstaller;
import org.nakedobjects.runtime.authorization.AuthorizationManagerInstaller;
import org.nakedobjects.runtime.authorization.standard.noop.NoopAuthorizationManagerInstaller;
import org.nakedobjects.runtime.fixturesinstaller.FixturesInstaller;
import org.nakedobjects.runtime.imageloader.TemplateImageLoaderInstaller;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.installers.InstallerLookupAware;
import org.nakedobjects.runtime.persistence.PersistenceMechanismInstaller;
import org.nakedobjects.runtime.persistence.services.ServicesInstaller;
import org.nakedobjects.runtime.remoting.ClientConnectionInstaller;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.userprofile.UserProfileStoreInstaller;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerInstaller;
import org.nakedobjects.runtime.web.EmbeddedWebServerInstaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerLookupDefault
implements InstallerLookup {
    private static final Logger LOG = Logger.getLogger(InstallerLookupDefault.class);
    public final String INSTALLER_REGISTRY_FILE = "installer-registry.properties";
    private final List<Installer> installerList = new ArrayList<Installer>();
    private final Class<?> cls;
    private ConfigurationBuilder configurationBuilder;

    public InstallerLookupDefault(Class<?> cls) {
        this.cls = cls;
        this.loadInstallers();
    }

    /*
     * Exception decompiling
     */
    private void loadInstallers() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Installer[] getInstallers(Class<?> cls) {
        ArrayList<Installer> list = new ArrayList<Installer>();
        for (Installer comp : this.installerList) {
            if (!cls.isAssignableFrom(comp.getClass())) continue;
            list.add(comp);
        }
        return list.toArray(new Installer[list.size()]);
    }

    public void init() {
        this.ensureDependenciesInjected();
    }

    private void ensureDependenciesInjected() {
        Ensure.ensureThatState((Object)this.configurationBuilder, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    public void shutdown() {
    }

    @Override
    public AuthenticationManagerInstaller authenticationManagerInstaller(String requested, boolean isProduction) {
        return this.getInstaller(AuthenticationManagerInstaller.class, requested, "nakedobjects.authentication", isProduction ? "file" : NoopAuthenticationManagerInstaller.class.getName());
    }

    @Override
    public AuthorizationManagerInstaller authorizationManagerInstaller(String requested, boolean isProduction) {
        return this.getInstaller(AuthorizationManagerInstaller.class, requested, "nakedobjects.authorization", isProduction ? "file" : NoopAuthorizationManagerInstaller.class.getName());
    }

    @Override
    public FixturesInstaller fixturesInstaller(String requested) {
        return this.getInstaller(FixturesInstaller.class, requested, "nakedobjects.fixtures-installer", "configuration");
    }

    @Override
    public TemplateImageLoaderInstaller templateImageLoaderInstaller(String requested) {
        return this.getInstaller(TemplateImageLoaderInstaller.class, requested, "nakedobjects.template-image-loader", "awt");
    }

    @Override
    public PersistenceMechanismInstaller persistenceMechanismInstaller(String requested, DeploymentType deploymentType) {
        String persistorDefault = deploymentType.isExploring() || deploymentType.isPrototyping() ? "in-memory" : "xml";
        return this.getInstaller(PersistenceMechanismInstaller.class, requested, "nakedobjects.persistor", persistorDefault);
    }

    @Override
    public UserProfileStoreInstaller userProfilePersistenceMechanismInstaller(String requested, DeploymentType deploymentType) {
        String profileStoreDefault = deploymentType.isExploring() || deploymentType.isPrototyping() ? "in-memory" : "xml";
        return this.getInstaller(UserProfileStoreInstaller.class, requested, "nakedobjects.user-profile-store", profileStoreDefault);
    }

    @Override
    public NakedObjectReflectorInstaller reflectorInstaller(String requested) {
        return this.getInstaller(NakedObjectReflectorInstaller.class, requested, "nakedobjects.reflector", "java");
    }

    @Override
    public EmbeddedWebServerInstaller embeddedWebServerInstaller(String requested) {
        return this.getInstaller(EmbeddedWebServerInstaller.class, requested, "nakedobjects.embedded-web-server", "jetty");
    }

    @Override
    public ClientConnectionInstaller clientConnectionInstaller(String requested) {
        return this.getInstaller(ClientConnectionInstaller.class, requested, "nakedobjects.connector", "encoding_socket");
    }

    @Override
    public NakedObjectsViewerInstaller viewerInstaller(String name, String defaultName) {
        String viewer = name == null ? this.getConfiguration().getString("nakedobjects.viewer", defaultName) : name;
        if (viewer == null) {
            return null;
        }
        return this.getInstaller(NakedObjectsViewerInstaller.class, viewer);
    }

    @Override
    public NakedObjectsViewerInstaller viewerInstaller(String name) {
        if (name == null) {
            throw new NakedObjectException("No viewer specified");
        }
        NakedObjectsViewerInstaller installer = this.getInstaller(NakedObjectsViewerInstaller.class, name);
        if (installer == null) {
            throw new NakedObjectException("No viewer of type " + name);
        }
        return installer;
    }

    @Override
    public ServicesInstaller servicesInstaller(String requestedImplementationName) {
        return this.getInstaller(ServicesInstaller.class, requestedImplementationName, "nakedobjects.services-installer", "configuration");
    }

    @Override
    public <T extends Installer> T getInstaller(Class<T> cls, String implName) {
        if (implName == null) {
            throw new IllegalArgumentException("No name specified");
        }
        for (Installer installer : this.installerList) {
            if (!cls.isAssignableFrom(installer.getClass()) || !installer.getName().equals(implName)) continue;
            this.mergeConfigurationFor(installer);
            this.injectDependenciesInto(installer);
            return (T)installer;
        }
        return (T)this.getInstaller(implName);
    }

    public Installer getInstaller(String implClassName) {
        try {
            Installer installer = (Installer)CastUtils.cast((Object)InstanceFactory.createInstance((String)implClassName));
            if (installer != null) {
                this.mergeConfigurationFor(installer);
                this.injectDependenciesInto(installer);
            }
            return installer;
        }
        catch (InstanceCreationException e) {
            throw new InstanceCreationException("Specification error in installer-registry.properties", (Throwable)e);
        }
        catch (UnavailableClassException e) {
            return null;
        }
    }

    @Override
    public <T extends Installer> T getInstaller(Class<T> installerCls) {
        try {
            Installer installer = (Installer)InstanceFactory.createInstance(installerCls);
            if (installer != null) {
                this.mergeConfigurationFor(installer);
                this.injectDependenciesInto(installer);
            }
            return (T)installer;
        }
        catch (InstanceCreationException e) {
            throw new InstanceCreationException("Specification error in installer-registry.properties", (Throwable)e);
        }
        catch (UnavailableClassException e) {
            return null;
        }
    }

    private <T extends Installer> T getInstaller(Class<T> requiredType, String reqImpl, String key, String defaultImpl) {
        if (reqImpl == null) {
            reqImpl = this.getConfiguration().getString(key, defaultImpl);
        }
        if (reqImpl == null) {
            return null;
        }
        T installer = this.getInstaller(requiredType, reqImpl);
        if (installer == null) {
            throw new InstanceCreationException("Failed to load installer class " + reqImpl + " (of type " + requiredType.getName());
        }
        return installer;
    }

    private void close(BufferedReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new NakedObjectException((Throwable)e);
            }
        }
    }

    private InputStream getInstallerRegistryStream(String componentFile, Class<?> cls) {
        InputStream in = cls.getResourceAsStream("/" + componentFile);
        if (in == null) {
            throw new NakedObjectException("No resource found: " + componentFile);
        }
        return in;
    }

    @Override
    public NakedObjectConfiguration getConfiguration() {
        return this.configurationBuilder.getConfiguration();
    }

    public void mergeConfigurationFor(Installer installer) {
        if (installer != null) {
            for (String installerConfigResource : installer.getConfigurationResources()) {
                this.configurationBuilder.addConfigurationResource(installerConfigResource, NotFoundPolicy.CONTINUE);
            }
        }
    }

    @Override
    public <T> T injectDependenciesInto(T candidate) {
        this.injectInto(candidate);
        return candidate;
    }

    public void injectInto(Object candidate) {
        if (InstallerLookupAware.class.isAssignableFrom(candidate.getClass())) {
            InstallerLookupAware cast = (InstallerLookupAware)InstallerLookupAware.class.cast(candidate);
            cast.setInstallerLookup(this);
        }
        this.configurationBuilder.injectInto(candidate);
    }

    @Override
    public ConfigurationBuilder getConfigurationBuilder() {
        return this.configurationBuilder;
    }

    public void setConfigurationBuilder(ConfigurationBuilder configurationLoader) {
        this.configurationBuilder = configurationLoader;
    }
}

