/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.logging;

import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSource;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSourceComposite;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSourceContextLoaderClassPath;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSourceFileSystem;
import org.nakedobjects.metamodel.config.internal.PropertiesReader;

public class NakedObjectsLoggingConfigurer {
    public void configureLogging(String[] args) {
        this.configureLogging("config", args);
    }

    public void configureLogging(String configDirectory, String[] args) {
        this.configureLogging(configDirectory);
        Level loggingLevel = this.loggingLevel(args);
        if (loggingLevel != null) {
            Logger.getRootLogger().setLevel(loggingLevel);
        }
    }

    public void configureLogging(String configDirectory) {
        this.configureLogging((ResourceStreamSource)new ResourceStreamSourceComposite(new ResourceStreamSource[]{new ResourceStreamSourceFileSystem(configDirectory), new ResourceStreamSourceContextLoaderClassPath()}));
    }

    public void configureLogging(ResourceStreamSource resourceStreamSource) {
        try {
            PropertiesReader propertiesReader = new PropertiesReader(resourceStreamSource, "logging.properties");
            PropertyConfigurator.configure((Properties)propertiesReader.getProperties());
        }
        catch (IOException ex) {
            this.configureFallbackLogging();
        }
    }

    private void configureFallbackLogging() {
        PatternLayout layout = new PatternLayout("%-5r [%-25.25c{1} %-10.10t %-5.5p]  %m%n");
        ConsoleAppender appender = new ConsoleAppender((Layout)layout);
        BasicConfigurator.configure((Appender)appender);
        Logger.getRootLogger().setLevel(Level.WARN);
        Logger.getLogger((String)"ui").setLevel(Level.OFF);
    }

    private Level loggingLevel(String[] args) {
        Level level = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-debug")) {
                level = Level.DEBUG;
                break;
            }
            if (args[i].equals("-quiet")) {
                level = Level.ERROR;
                break;
            }
            if (!args[i].equals("-verbose")) continue;
            level = Level.INFO;
            break;
        }
        return level;
    }
}

