/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.memento;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.runtime.memento.Data;
import org.nakedobjects.runtime.memento.Null;

class ObjectData
extends Data {
    private static final long serialVersionUID = 7121411963269613347L;
    private static final Encodable NO_ENTRY = new Null();
    private final Map<String, Object> fields = new HashMap<String, Object>();

    public ObjectData(Oid oid, String resolveState, String className) {
        super(oid, resolveState, className);
        this.initialized();
    }

    public ObjectData(DataInputExtended input) throws IOException {
        super(input);
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            String key = input.readUTF();
            As as = As.readFrom(input);
            if (as == As.OBJECT) {
                Data object = (Data)input.readEncodable(Data.class);
                this.fields.put(key, object);
                continue;
            }
            if (as == As.NULL) {
                this.fields.put(key, NO_ENTRY);
                continue;
            }
            String value = input.readUTF();
            this.fields.put(key, value);
        }
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeInt(this.fields.size());
        for (String key : this.fields.keySet()) {
            Object value = this.fields.get(key);
            output.writeUTF(key);
            if (value instanceof Data) {
                As.OBJECT.writeTo(output);
                output.writeEncodable(value);
                continue;
            }
            if (value instanceof Null) continue;
            output.writeUTF(As.STRING.name());
            output.writeUTF((String)value);
        }
    }

    private void initialized() {
    }

    public void addField(String fieldName, Object entry) {
        if (this.fields.containsKey(fieldName)) {
            throw new IllegalArgumentException("Field already entered " + fieldName);
        }
        this.fields.put(fieldName, entry == null ? NO_ENTRY : entry);
    }

    public boolean containsField() {
        return this.fields != null && this.fields.size() > 0;
    }

    public Object getEntry(String fieldName) {
        Object entry = this.fields.get(fieldName);
        return entry == null || entry.getClass() == NO_ENTRY.getClass() ? null : entry;
    }

    public String toString() {
        return this.fields.toString();
    }

    public void debug(DebugString debug) {
        super.debug(debug);
        for (String key : this.fields.keySet()) {
            Object value = this.fields.get(key);
            debug.appendln(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum As {
        OBJECT(0),
        NULL(1),
        STRING(2);

        static Map<Integer, As> cache;
        private final int idx;

        private As(int idx) {
            this.idx = idx;
        }

        static As get(int idx) {
            return cache.get(idx);
        }

        public static As readFrom(DataInputExtended input) throws IOException {
            return As.get(input.readByte());
        }

        public void writeTo(DataOutputExtended output) throws IOException {
            output.writeByte(this.idx);
        }

        static {
            cache = new HashMap<Integer, As>();
            for (As as : As.values()) {
                cache.put(as.idx, as);
            }
        }
    }
}

