/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.memento;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.memento.Data;

public class StandaloneData
extends Data {
    private static final long serialVersionUID = 1L;
    private String objectAsEncodedString;
    private Serializable objectAsSerializable;

    public StandaloneData(NakedObject adapter) {
        super(null, adapter.getResolveState().name(), adapter.getSpecification().getFullName());
        Object object = adapter.getObject();
        if (object instanceof Serializable) {
            this.objectAsSerializable = (Serializable)object;
            this.initialized();
            return;
        }
        EncodableFacet encodeableFacet = (EncodableFacet)adapter.getSpecification().getFacet(EncodableFacet.class);
        if (encodeableFacet != null) {
            this.objectAsEncodedString = encodeableFacet.toEncodedString(adapter);
            this.initialized();
            return;
        }
        throw new IllegalArgumentException("Object wrapped by standalone adapter is not serializable and its specificatoin does not have an EncodeableFacet");
    }

    public StandaloneData(DataInputExtended input) throws IOException {
        super(input);
        As as = As.readFrom(input);
        if (as == As.SERIALIZABLE) {
            this.objectAsSerializable = (Serializable)input.readSerializable(Serializable.class);
        } else {
            this.objectAsEncodedString = input.readUTF();
        }
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        if (this.objectAsSerializable != null) {
            As.SERIALIZABLE.writeTo(output);
            output.writeSerializable((Object)this.objectAsSerializable);
        } else {
            As.ENCODED_STRING.writeTo(output);
            output.writeUTF(this.objectAsEncodedString);
        }
    }

    private void initialized() {
    }

    public NakedObject getAdapter() {
        if (this.objectAsSerializable != null) {
            return NakedObjectsContext.getPersistenceSession().getAdapterManager().adapterFor(this.objectAsSerializable);
        }
        NakedObjectSpecification spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(this.getClassName());
        EncodableFacet encodeableFacet = (EncodableFacet)spec.getFacet(EncodableFacet.class);
        return encodeableFacet.fromEncodedString(this.objectAsEncodedString);
    }

    private String getObjectAsEncodedString() {
        return this.objectAsEncodedString;
    }

    private Serializable getObjectAsSerializable() {
        return this.objectAsSerializable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum As {
        ENCODED_STRING(0),
        SERIALIZABLE(1);

        static Map<Integer, As> cache;
        private final int idx;

        private As(int idx) {
            this.idx = idx;
        }

        static As get(int idx) {
            return cache.get(idx);
        }

        public static As readFrom(DataInputExtended input) throws IOException {
            return As.get(input.readByte());
        }

        public void writeTo(DataOutputExtended output) throws IOException {
            output.writeByte(this.idx);
        }

        static {
            cache = new HashMap<Integer, As>();
            for (As as : As.values()) {
                cache.put(as.idx, as);
            }
        }
    }
}

