/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.objectstore.inmemory;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.debug.Debug;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.objectstore.inmemory.InMemoryPersistenceSessionFactory;
import org.nakedobjects.runtime.objectstore.inmemory.internal.ObjectStoreInstances;
import org.nakedobjects.runtime.objectstore.inmemory.internal.ObjectStorePersistedObjects;
import org.nakedobjects.runtime.objectstore.inmemory.internal.ObjectStorePersistedObjectsDefault;
import org.nakedobjects.runtime.objectstore.inmemory.internal.commands.InMemoryCreateObjectCommand;
import org.nakedobjects.runtime.objectstore.inmemory.internal.commands.InMemoryDestroyObjectCommand;
import org.nakedobjects.runtime.objectstore.inmemory.internal.commands.InMemorySaveObjectCommand;
import org.nakedobjects.runtime.persistence.ObjectNotFoundException;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.PersistenceSessionHydrator;
import org.nakedobjects.runtime.persistence.PersistorUtil;
import org.nakedobjects.runtime.persistence.UnsupportedFindException;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStore;
import org.nakedobjects.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryBuiltIn;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;
import org.nakedobjects.runtime.transaction.PersistenceCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryObjectStore
implements ObjectStore {
    private static final Logger LOG = Logger.getLogger(InMemoryObjectStore.class);
    protected ObjectStorePersistedObjects persistedObjects;

    public InMemoryObjectStore() {
        LOG.info((Object)"creating memory object store");
    }

    public String name() {
        return "In-Memory Object Store";
    }

    public void open() {
        if (this.persistedObjects == null) {
            InMemoryPersistenceSessionFactory inMemoryPersistenceSessionFactory = this.getInMemoryPersistenceSessionFactory();
            this.persistedObjects = inMemoryPersistenceSessionFactory != null ? inMemoryPersistenceSessionFactory.createPersistedObjects() : new ObjectStorePersistedObjectsDefault();
        } else {
            this.recreateAdapters();
        }
    }

    private void recreateAdapters() {
        for (NakedObjectSpecification noSpec : this.persistedObjects.specifications()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("recreating adapters for: " + noSpec.getFullName()));
            }
            this.recreateAdapters(this.persistedObjects.instancesFor(noSpec));
        }
    }

    private void recreateAdapters(ObjectStoreInstances objectStoreInstances) {
        Map<Oid, Object> objectByOidMap = objectStoreInstances.getObjectInstances();
        for (Oid oid : objectStoreInstances.getOids()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("recreating adapter: oid=" + oid));
            }
            Object pojo = objectStoreInstances.getPojo(oid);
            NakedObject existingAdapterLookedUpByPojo = this.getAdapterManager().getAdapterFor(pojo);
            if (existingAdapterLookedUpByPojo != null) {
                this.getAdapterManager().removeAdapter(existingAdapterLookedUpByPojo);
            }
            NakedObject existingAdapterLookedUpByOid = this.getAdapterManager().getAdapterFor(oid);
            Ensure.ensureThatState((Object)existingAdapterLookedUpByOid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (String)("Already have mapping for " + oid));
            NakedObject recreatedAdapter = this.getHydrator().recreateAdapter(oid, pojo);
            Version version = objectStoreInstances.getVersion(oid);
            recreatedAdapter.setOptimisticLock(version);
        }
    }

    public void close() {
        InMemoryPersistenceSessionFactory inMemoryPersistenceSessionFactory = this.getInMemoryPersistenceSessionFactory();
        if (inMemoryPersistenceSessionFactory != null) {
            inMemoryPersistenceSessionFactory.attach(this.getPersistenceSession(), this.persistedObjects);
            this.persistedObjects = null;
        }
    }

    @Override
    public boolean isFixturesInstalled() {
        return false;
    }

    @Override
    public void reset() {
    }

    public void attachPersistedObjects(ObjectStorePersistedObjects persistedObjects) {
        this.persistedObjects = persistedObjects;
    }

    @Override
    public void startTransaction() {
    }

    @Override
    public void endTransaction() {
    }

    @Override
    public void abortTransaction() {
    }

    @Override
    public CreateObjectCommand createCreateObjectCommand(NakedObject object) {
        return new InMemoryCreateObjectCommand(object, this.persistedObjects);
    }

    @Override
    public SaveObjectCommand createSaveObjectCommand(NakedObject object) {
        return new InMemorySaveObjectCommand(object, this.persistedObjects);
    }

    @Override
    public DestroyObjectCommand createDestroyObjectCommand(NakedObject object) {
        return new InMemoryDestroyObjectCommand(object, this.persistedObjects);
    }

    @Override
    public void execute(List<PersistenceCommand> commands) throws ObjectPersistenceException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"execute commands");
        }
        for (PersistenceCommand command : commands) {
            command.execute(null);
        }
        LOG.info((Object)"end execution");
    }

    @Override
    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) throws ObjectNotFoundException, ObjectPersistenceException {
        LOG.debug((Object)("getObject " + oid));
        ObjectStoreInstances ins = this.instancesFor(hint);
        NakedObject object = ins.retrieveObject(oid);
        if (object == null) {
            throw new ObjectNotFoundException(oid);
        }
        this.setupReferencedObjects(object);
        return object;
    }

    @Override
    public void resolveImmediately(NakedObject adapter) throws ObjectPersistenceException {
        if (adapter.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
            LOG.debug((Object)("resolve " + adapter));
            this.setupReferencedObjects(adapter);
            PersistorUtil.start(adapter, ResolveState.RESOLVING);
            PersistorUtil.end(adapter);
        } else {
            LOG.warn((Object)("resolveImmediately ignored, adapter's current state is: " + adapter.getResolveState() + " ; oid: " + adapter.getOid()));
        }
    }

    @Override
    public void resolveField(NakedObject object, NakedObjectAssociation field) throws ObjectPersistenceException {
        NakedObject reference = field.get(object);
        PersistorUtil.start(reference, ResolveState.RESOLVING);
        PersistorUtil.end(reference);
    }

    private void setupReferencedObjects(NakedObject object) {
        this.setupReferencedObjects(object, new Vector());
    }

    private void setupReferencedObjects(NakedObject adapter, Vector all) {
    }

    @Override
    public NakedObject[] getInstances(PersistenceQuery persistenceQuery) throws ObjectPersistenceException, UnsupportedFindException {
        if (!(persistenceQuery instanceof PersistenceQueryBuiltIn)) {
            throw new IllegalArgumentException(MessageFormat.format("Provided PersistenceQuery not supported; was {0}; the in-memory object store only supports {1}", persistenceQuery.getClass().getName(), PersistenceQueryBuiltIn.class.getName()));
        }
        PersistenceQueryBuiltIn builtIn = (PersistenceQueryBuiltIn)persistenceQuery;
        Vector<NakedObject> instances = new Vector<NakedObject>();
        NakedObjectSpecification spec = persistenceQuery.getSpecification();
        this.findInstances(spec, builtIn, instances);
        return this.toInstancesArray(instances);
    }

    @Override
    public boolean hasInstances(NakedObjectSpecification spec) {
        if (this.instancesFor(spec).hasInstances()) {
            return true;
        }
        NakedObjectSpecification[] subclasses = spec.subclasses();
        for (int i = 0; i < subclasses.length; ++i) {
            if (!this.hasInstances(subclasses[i])) continue;
            return true;
        }
        return false;
    }

    private void findInstances(NakedObjectSpecification spec, PersistenceQueryBuiltIn persistenceQuery, Vector<NakedObject> foundInstances) {
        this.instancesFor(spec).findInstancesAndAdd(persistenceQuery, foundInstances);
        NakedObjectSpecification[] subclasses = spec.subclasses();
        for (int i = 0; i < subclasses.length; ++i) {
            this.findInstances(subclasses[i], persistenceQuery, foundInstances);
        }
    }

    private NakedObject[] toInstancesArray(Vector<NakedObject> instances) {
        NakedObject[] ins = new NakedObject[instances.size()];
        for (int i = 0; i < ins.length; ++i) {
            NakedObject object = instances.elementAt(i);
            this.setupReferencedObjects(object);
            if (object.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
                PersistorUtil.start(object, ResolveState.RESOLVING);
                PersistorUtil.end(object);
            }
            ins[i] = object;
        }
        return ins;
    }

    @Override
    public Oid getOidForService(String name) {
        return this.persistedObjects.getService(name);
    }

    @Override
    public void registerService(String name, Oid oid) {
        this.persistedObjects.registerService(name, oid);
    }

    private ObjectStoreInstances instancesFor(NakedObjectSpecification spec) {
        return this.persistedObjects.instancesFor(spec);
    }

    public String debugTitle() {
        return this.name();
    }

    public void debugData(DebugString debug) {
        debug.appendTitle("Domain Objects");
        for (NakedObjectSpecification spec : this.persistedObjects.specifications()) {
            debug.appendln(spec.getFullName());
            ObjectStoreInstances instances = this.instancesFor(spec);
            instances.debugData(debug);
        }
        debug.unindent();
        debug.appendln();
    }

    private String debugCollectionGraph(NakedObject collection, int level, Vector recursiveElements) {
        StringBuffer s = new StringBuffer();
        if (recursiveElements.contains(collection)) {
            s.append("*\n");
        } else {
            recursiveElements.addElement(collection);
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
            Iterator e = facet.iterator(collection);
            while (e.hasNext()) {
                NakedObject element;
                this.indent(s, level);
                try {
                    element = (NakedObject)e.next();
                }
                catch (ClassCastException ex) {
                    LOG.error((Object)ex);
                    return s.toString();
                }
                s.append(element);
                s.append(this.debugGraph(element, level + 1, recursiveElements));
            }
        }
        return s.toString();
    }

    private String debugGraph(NakedObject object, int level, Vector recursiveElements) {
        if (level > 3) {
            return "...\n";
        }
        Vector elements = recursiveElements == null ? new Vector(25, 10) : recursiveElements;
        if (object.getSpecification().isCollection()) {
            return "\n" + this.debugCollectionGraph(object, level, elements);
        }
        return "\n" + this.debugObjectGraph(object, level, elements);
    }

    private String debugObjectGraph(NakedObject object, int level, Vector recursiveElements) {
        StringBuffer s = new StringBuffer();
        recursiveElements.addElement(object);
        NakedObjectAssociation[] fields = object.getSpecification().getAssociations();
        for (int i = 0; i < fields.length; ++i) {
            NakedObjectAssociation field = fields[i];
            NakedObject obj = field.get(object);
            String id = field.getId();
            this.indent(s, level);
            if (field.isOneToManyAssociation()) {
                s.append(id + ": \n" + this.debugCollectionGraph(obj, level + 1, recursiveElements));
                continue;
            }
            if (obj instanceof NakedObject) {
                if (recursiveElements.contains(obj)) {
                    s.append(id + ": " + obj + "*\n");
                    continue;
                }
                s.append(id + ": " + obj);
                s.append(this.debugGraph(obj, level + 1, recursiveElements));
                continue;
            }
            s.append(id + ": " + obj);
            s.append("\n");
        }
        return s.toString();
    }

    private void indent(StringBuffer s, int level) {
        for (int indent = 0; indent < level; ++indent) {
            s.append(Debug.indentString((int)4) + "|");
        }
        s.append(Debug.indentString((int)4) + "+--");
    }

    private PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    private PersistenceSessionHydrator getHydrator() {
        return this.getPersistenceSession();
    }

    protected InMemoryPersistenceSessionFactory getInMemoryPersistenceSessionFactory() {
        PersistenceSessionFactory persistenceSessionFactory = this.getPersistenceSession().getPersistenceSessionFactory();
        if (!(persistenceSessionFactory instanceof InMemoryPersistenceSessionFactory)) {
            return null;
        }
        return (InMemoryPersistenceSessionFactory)persistenceSessionFactory;
    }
}

