/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.objectstore.inmemory.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.nakedobjects.applib.clock.Clock;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.SerialNumberVersion;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionHydrator;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryBuiltIn;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryFindByTitle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectStoreInstances {
    private final Map<Oid, Object> pojoByOidMap = new HashMap<Oid, Object>();
    private final Map<Oid, String> titleByOidMap = new HashMap<Oid, String>();
    private final Map<Oid, SerialNumberVersion> versionByOidMap = new HashMap<Oid, SerialNumberVersion>();
    private final NakedObjectSpecification spec;

    public ObjectStoreInstances(NakedObjectSpecification spec) {
        this.spec = spec;
    }

    public Map<Oid, Object> getObjectInstances() {
        return this.pojoByOidMap;
    }

    public Set<Oid> getOids() {
        return Collections.unmodifiableSet(this.pojoByOidMap.keySet());
    }

    public Object getPojo(Oid oid) {
        return this.pojoByOidMap.get(oid);
    }

    public Version getVersion(Oid oid) {
        return (Version)this.versionByOidMap.get(oid);
    }

    public void shutdown() {
        this.pojoByOidMap.clear();
        this.titleByOidMap.clear();
        this.versionByOidMap.clear();
    }

    public void save(NakedObject adapter) {
        this.pojoByOidMap.put(adapter.getOid(), adapter.getObject());
        this.titleByOidMap.put(adapter.getOid(), adapter.titleString().toLowerCase());
        SerialNumberVersion version = this.versionByOidMap.get(adapter.getOid());
        SerialNumberVersion nextVersion = this.nextVersion(version);
        this.versionByOidMap.put(adapter.getOid(), nextVersion);
        adapter.setOptimisticLock((Version)nextVersion);
    }

    private synchronized SerialNumberVersion nextVersion(SerialNumberVersion version) {
        long sequence = (version != null ? version.getSequence() : 0L) + 1L;
        return new SerialNumberVersion(sequence, ObjectStoreInstances.getAuthenticationSession().getUserName(), new Date(Clock.getTime()));
    }

    public void remove(Oid oid) {
        this.pojoByOidMap.remove(oid);
        this.titleByOidMap.remove(oid);
        this.versionByOidMap.remove(oid);
    }

    public NakedObject retrieveObject(Oid oid) {
        Object pojo = this.getObjectInstances().get(oid);
        if (pojo == null) {
            return null;
        }
        NakedObject adapterLookedUpByPojo = this.getAdapterManager().getAdapterFor(pojo);
        if (adapterLookedUpByPojo != null) {
            return adapterLookedUpByPojo;
        }
        NakedObject adapterLookedUpByOid = this.getAdapterManager().getAdapterFor(oid);
        if (adapterLookedUpByOid != null) {
            return adapterLookedUpByOid;
        }
        return this.getHydrator().recreateAdapter(oid, pojo);
    }

    public void findInstancesAndAdd(PersistenceQueryBuiltIn persistenceQuery, Vector<NakedObject> foundInstances) {
        if (persistenceQuery instanceof PersistenceQueryFindByTitle) {
            for (Oid oid : this.titleByOidMap.keySet()) {
                String title = this.titleByOidMap.get(oid);
                if (!((PersistenceQueryFindByTitle)persistenceQuery).matches(title)) continue;
                NakedObject adapter = this.retrieveObject(oid);
                foundInstances.add(adapter);
            }
            return;
        }
        for (NakedObject element : this.elements()) {
            if (!persistenceQuery.matches(element)) continue;
            foundInstances.addElement(element);
        }
    }

    public int numberOfInstances() {
        return this.getObjectInstances().size();
    }

    public boolean hasInstances() {
        return this.numberOfInstances() > 0;
    }

    private List<NakedObject> elements() {
        ArrayList<NakedObject> v = new ArrayList<NakedObject>(this.getObjectInstances().size());
        for (Oid oid : this.getObjectInstances().keySet()) {
            v.add(this.retrieveObject(oid));
        }
        return v;
    }

    public void debugData(DebugString debug) {
        debug.indent();
        if (this.getObjectInstances().size() == 0) {
            debug.appendln("no instances");
        }
        for (Oid oid : this.getObjectInstances().keySet()) {
            String title = this.titleByOidMap.get(oid);
            Object object = this.getObjectInstances().get(oid);
            debug.appendln(oid.toString(), (Object)(object + " (" + title + ")"));
        }
        debug.appendln();
        debug.unindent();
    }

    private PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    private PersistenceSessionHydrator getHydrator() {
        return this.getPersistenceSession();
    }

    private static AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }
}

