/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.objectstore.inmemory.internal;

import java.util.HashMap;
import java.util.Map;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.runtime.objectstore.inmemory.internal.ObjectStoreInstances;
import org.nakedobjects.runtime.objectstore.inmemory.internal.ObjectStorePersistedObjects;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SimpleOidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStorePersistedObjectsDefault
implements ObjectStorePersistedObjects {
    private final Map<NakedObjectSpecification, ObjectStoreInstances> instancesBySpecMap = new HashMap<NakedObjectSpecification, ObjectStoreInstances>();
    private final Map<String, Oid> serviceOidByIdMap = new HashMap<String, Oid>();
    private SimpleOidGenerator.Memento oidGeneratorMemento;

    @Override
    public SimpleOidGenerator.Memento getOidGeneratorMemento() {
        return this.oidGeneratorMemento;
    }

    @Override
    public void saveOidGeneratorMemento(SimpleOidGenerator.Memento memento) {
        this.oidGeneratorMemento = memento;
    }

    @Override
    public Oid getService(String name) {
        return this.serviceOidByIdMap.get(name);
    }

    @Override
    public void registerService(String name, Oid oid) {
        Oid oidLookedUpByName = this.serviceOidByIdMap.get(name);
        if (oidLookedUpByName != null) {
            if (!oidLookedUpByName.equals(oid)) {
                throw new NakedObjectException("Already another service registered as name: " + name + " (existing Oid: " + oidLookedUpByName + ", " + "intended: " + oid + ")");
            }
        } else {
            this.serviceOidByIdMap.put(name, oid);
        }
    }

    @Override
    public ObjectStoreInstances instancesFor(NakedObjectSpecification spec) {
        ObjectStoreInstances ins = this.instancesBySpecMap.get(spec);
        if (ins == null) {
            ins = new ObjectStoreInstances(spec);
            this.instancesBySpecMap.put(spec, ins);
        }
        return ins;
    }

    @Override
    public Iterable<NakedObjectSpecification> specifications() {
        return this.instancesBySpecMap.keySet();
    }

    @Override
    public void clear() {
        this.instancesBySpecMap.clear();
    }

    @Override
    public Iterable<ObjectStoreInstances> instances() {
        return this.instancesBySpecMap.values();
    }
}

