/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.options.standard;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.nakedobjects.metamodel.commons.lang.ListUtils;
import org.nakedobjects.metamodel.config.ConfigurationBuilder;
import org.nakedobjects.runtime.installers.InstallerRepository;
import org.nakedobjects.runtime.options.BootPrinter;
import org.nakedobjects.runtime.options.OptionHandlerAbstract;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerInstaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionHandlerConnector
extends OptionHandlerAbstract {
    private InstallerRepository installerRepository;
    private List<String> connectorNames;

    public OptionHandlerConnector(InstallerRepository installerRepository) {
        this.installerRepository = installerRepository;
    }

    @Override
    public void addOption(Options options) {
        Object[] connectors = this.installerRepository.getInstallers(NakedObjectsViewerInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"connector");
        OptionBuilder.withDescription((String)("connector to use for client requests, or for server to listen on: " + this.availableInstallers(connectors)));
        Option option = OptionBuilder.create((String)"x");
        options.addOption(option);
    }

    @Override
    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.connectorNames = this.getOptionValues(commandLine, "x");
        return true;
    }

    public void primeConfigurationBuilder(ConfigurationBuilder configurationBuilder) {
        configurationBuilder.add("nakedobjects.connector", ListUtils.listToString(this.connectorNames));
    }

    public List<String> getConnectorNames() {
        return this.connectorNames;
    }
}

