/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.options.standard;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.nakedobjects.metamodel.config.ConfigurationBuilder;
import org.nakedobjects.metamodel.config.NotFoundPolicy;
import org.nakedobjects.runtime.options.BootPrinter;
import org.nakedobjects.runtime.options.Constants;
import org.nakedobjects.runtime.options.OptionHandlerAbstract;
import org.nakedobjects.runtime.system.DeploymentType;

public class OptionHandlerDeploymentType
extends OptionHandlerAbstract {
    private DeploymentType deploymentType;
    private boolean defaulted;
    private boolean primeIfDefaulted;

    public OptionHandlerDeploymentType() {
        this(true);
    }

    public OptionHandlerDeploymentType(boolean primeIfDefaulted) {
        this.primeIfDefaulted = primeIfDefaulted;
    }

    public void addOption(Options options) {
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"type");
        OptionBuilder.withDescription((String)("deployment type: " + Constants.TYPE_EXPLORATION + "; " + Constants.TYPE_PROTOTYPE + " (default); " + Constants.TYPE_SINGLE_USER + "; " + Constants.TYPE_CLIENT + "; " + Constants.TYPE_SERVER_EXPLORATION + "; " + Constants.TYPE_SERVER_PROTOTYPE + "; " + Constants.TYPE_SERVER + "; "));
        Option option = OptionBuilder.create((String)"t");
        options.addOption(option);
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        String deploymentTypeName = commandLine.getOptionValue("t");
        if (deploymentTypeName == null) {
            this.deploymentType = DeploymentType.PROTOTYPE;
            this.defaulted = true;
            return true;
        }
        this.deploymentType = DeploymentType.lookup(deploymentTypeName.toUpperCase());
        if (this.deploymentType != null) {
            return true;
        }
        bootPrinter.printErrorAndHelp(options, "Unable to determine deployment type", new Object[0]);
        return false;
    }

    public void primeConfigurationBuilder(ConfigurationBuilder configurationBuilder) {
        if (this.defaulted && !this.primeIfDefaulted) {
            return;
        }
        String type = this.deploymentType.name().toLowerCase();
        configurationBuilder.addConfigurationResource(type + ".properties", NotFoundPolicy.CONTINUE);
        configurationBuilder.add("nakedobjects.deploymentType", this.deploymentType.name());
        configurationBuilder.add("nakedobjects.deploymentType.defaulted", "" + this.defaulted);
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }
}

