/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.options.standard;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.nakedobjects.metamodel.commons.lang.ListUtils;
import org.nakedobjects.metamodel.config.ConfigurationBuilder;
import org.nakedobjects.runtime.installers.InstallerRepository;
import org.nakedobjects.runtime.options.BootPrinter;
import org.nakedobjects.runtime.options.OptionHandlerAbstract;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerInstaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionHandlerViewer
extends OptionHandlerAbstract {
    private InstallerRepository installerRepository;
    private List<String> viewerNames;

    public OptionHandlerViewer(InstallerRepository installerRepository) {
        this.installerRepository = installerRepository;
    }

    @Override
    public void addOption(Options options) {
        Object[] viewers = this.installerRepository.getInstallers(NakedObjectsViewerInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"viewer");
        OptionBuilder.withDescription((String)("viewer to use, or for server to listen on: " + this.availableInstallers(viewers) + "; or class name"));
        Option option = OptionBuilder.create((String)"v");
        options.addOption(option);
    }

    @Override
    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.viewerNames = this.getOptionValues(commandLine, "v");
        return true;
    }

    public void primeConfigurationBuilder(ConfigurationBuilder configurationBuilder) {
        configurationBuilder.add("nakedobjects.viewer", ListUtils.listToString(this.viewerNames));
    }

    public List<String> getViewerNames() {
        return this.viewerNames;
    }
}

