/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore.algorithm;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.runtime.persistence.NotPersistableException;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.PersistAlgorithm;

public abstract class PersistAlgorithmAbstract
implements PersistAlgorithm {
    public void init() {
    }

    public void shutdown() {
    }

    protected boolean alreadyPersistedOrNotPersistableOrServiceOrStandalone(NakedObject adapter) {
        return this.objectIsStandalone(adapter) || this.objectSpecIsService(adapter) || this.alreadyPersistedOrNotPersistable(adapter);
    }

    protected boolean alreadyPersistedOrNotPersistable(NakedObject adapter) {
        return adapter.isPersistent() || this.objectSpecNotPersistable(adapter);
    }

    protected void assertObjectNotPersistentAndPersistable(NakedObject object) {
        if (this.alreadyPersistedOrNotPersistable(object)) {
            throw new NotPersistableException("can't make object persistent - either already persistent, or transient only: " + object);
        }
    }

    private boolean objectIsStandalone(NakedObject adapter) {
        return adapter.getResolveState().isValue();
    }

    private boolean objectSpecNotPersistable(NakedObject adapter) {
        return !adapter.getSpecification().persistability().isPersistable();
    }

    private boolean objectSpecIsService(NakedObject adapter) {
        return adapter.getSpecification().isService();
    }
}

