/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore.algorithm.topdown;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.util.CallbackUtils;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.PersistAlgorithmAbstract;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;

public class TopDownPersistAlgorithm
extends PersistAlgorithmAbstract {
    private static final Logger LOG = Logger.getLogger(TopDownPersistAlgorithm.class);

    public void makePersistent(NakedObject object, ToPersistObjectSet toPersistObjectSet) {
        if (object.getSpecification().isCollection()) {
            this.makeCollectionPersistent(object, toPersistObjectSet);
        } else {
            this.makeObjectPersistent(object, toPersistObjectSet);
        }
    }

    private void makeObjectPersistent(NakedObject object, ToPersistObjectSet toPersistObjectSet) {
        if (this.alreadyPersistedOrNotPersistableOrServiceOrStandalone(object)) {
            LOG.warn((Object)("can't make object persistent - either already persistent, or transient only: " + object));
            return;
        }
        NakedObjectAssociation[] fields = object.getSpecification().getAssociations();
        if (!object.getSpecification().isEncodeable() && fields.length > 0) {
            LOG.info((Object)("persist " + object));
            CallbackUtils.callCallback((NakedObject)object, PersistingCallbackFacet.class);
            toPersistObjectSet.remapAsPersistent(object);
            toPersistObjectSet.addPersistedObject(object);
            CallbackUtils.callCallback((NakedObject)object, PersistedCallbackFacet.class);
            for (int i = 0; i < fields.length; ++i) {
                NakedObjectAssociation field = fields[i];
                if (!field.isNotDerived()) continue;
                if (field instanceof OneToManyAssociation) {
                    NakedObject collection = field.get(object);
                    if (collection == null) {
                        throw new ObjectPersistenceException("Collection " + field.getName() + " does not exist in " + object.getSpecification().getFullName());
                    }
                    this.makePersistent(collection, toPersistObjectSet);
                    continue;
                }
                NakedObject fieldValue = field.get(object);
                if (fieldValue == null) continue;
                if (!(fieldValue instanceof NakedObject)) {
                    throw new NakedObjectException(fieldValue + " is not a NakedObject");
                }
                this.makePersistent(fieldValue, toPersistObjectSet);
            }
        }
    }

    private void makeCollectionPersistent(NakedObject collection, ToPersistObjectSet toPersistObjectSet) {
        LOG.info((Object)("persist " + collection));
        if (collection.getResolveState() == ResolveState.TRANSIENT) {
            collection.changeState(ResolveState.RESOLVED);
        }
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        Enumeration elements = facet.elements(collection);
        while (elements.hasMoreElements()) {
            this.makePersistent((NakedObject)elements.nextElement(), toPersistObjectSet);
        }
    }

    public String name() {
        return "Simple Top Down Persistence Walker";
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        return toString.toString();
    }
}

