/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.oidgenerator.simple;

import java.io.IOException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.oid.stringable.directly.DirectlyStringableOid;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.ensure.Assert;

public final class SerialOid
implements Oid,
Encodable,
Serializable,
DirectlyStringableOid {
    private static final long serialVersionUID = 1L;
    private int hashCode;
    private State state;
    private SerialOid previous;
    private long newSerialNo;
    private long serialNo;
    private String toString;
    private String enString;
    private static final String TOSTRING_SERIAL_NUM_PREFIX = "#";
    private static final String TOSTRING_PREVIOUS_CONCAT = "+";
    private static final String ENSTRING_SERIAL_NUM_PREFIX = ":";
    private static final String ENSTRING_PREVIOUS_CONCAT = "~";
    private static Pattern DESTRING_PATTERN = Pattern.compile("^(T?)OID:(-?[0-9A-F]+)(~(T?)OID:(-?[0-9A-F]+))?$");

    public static SerialOid createPersistent(long serialNo) {
        return new SerialOid(serialNo, State.PERSISTENT);
    }

    public static SerialOid createTransient(long serialNo) {
        return new SerialOid(serialNo, State.TRANSIENT);
    }

    private SerialOid(long serialNo, State state) {
        this.serialNo = serialNo;
        this.state = state;
        this.initialized();
    }

    public SerialOid(DataInputExtended input) throws IOException {
        this.serialNo = input.readLong();
        this.state = input.readBoolean() ? State.TRANSIENT : State.PERSISTENT;
        boolean hasPrevious = input.readBoolean();
        if (hasPrevious) {
            long previousSerialNo = input.readLong();
            State previousState = input.readBoolean() ? State.TRANSIENT : State.PERSISTENT;
            this.previous = new SerialOid(previousSerialNo, previousState);
        }
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        output.writeLong(this.serialNo);
        output.writeBoolean(this.state.isTransient());
        boolean hasPrevious = this.previous != null;
        output.writeBoolean(hasPrevious);
        if (hasPrevious) {
            output.writeLong(this.previous.serialNo);
            output.writeBoolean(this.previous.state.isTransient());
        }
    }

    private void initialized() {
        this.cacheState();
    }

    public static SerialOid deString(String oidStr) {
        Matcher matcher = DESTRING_PATTERN.matcher(oidStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Could not parse OID '" + oidStr + "'; should match pattern: " + DESTRING_PATTERN.toString());
        }
        String transientStr = matcher.group(1);
        String serialNumInHexStr = matcher.group(2);
        SerialOid oid = SerialOid.createOid(transientStr, serialNumInHexStr);
        String previousStr = matcher.group(3);
        if (!StringUtils.isEmpty((String)previousStr)) {
            String previousTransientStr = matcher.group(4);
            String previousSerialNumInHexStr = matcher.group(5);
            oid.previous = SerialOid.createOid(previousTransientStr, previousSerialNumInHexStr);
        }
        return oid;
    }

    private static SerialOid createOid(String transientStr, String serialNumInHexStr) {
        boolean isTransient = "T".equals(transientStr);
        long serialNum = Long.parseLong(serialNumInHexStr, 16);
        return isTransient ? SerialOid.createTransient(serialNum) : SerialOid.createPersistent(serialNum);
    }

    public String enString() {
        return this.enString;
    }

    public boolean isTransient() {
        return this.state.isTransient();
    }

    public void copyFrom(Oid oid) {
        Assert.assertTrue((boolean)(oid instanceof SerialOid));
        SerialOid from = (SerialOid)oid;
        this.serialNo = from.serialNo;
        this.state = from.state;
        this.cacheState();
    }

    public Oid getPrevious() {
        return this.previous;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    public void clearPrevious() {
        this.previous = null;
    }

    public void setId(long serialNo) {
        Assert.assertTrue((boolean)this.state.isTransient());
        this.newSerialNo = serialNo;
    }

    public void makePersistent() {
        Assert.assertTrue((boolean)this.state.isTransient());
        Assert.assertTrue((this.newSerialNo != 0L ? 1 : 0) != 0);
        this.previous = new SerialOid(this.serialNo, this.state);
        this.serialNo = this.newSerialNo;
        this.state = State.PERSISTENT;
        this.cacheState();
    }

    public long getSerialNo() {
        return this.serialNo;
    }

    private void cacheState() {
        this.hashCode = 17;
        this.hashCode = 37 * this.hashCode + (int)(this.serialNo ^ this.serialNo >>> 32);
        this.hashCode = 37 * this.hashCode + (this.isTransient() ? 0 : 1);
        this.toString = this.asString(this, TOSTRING_SERIAL_NUM_PREFIX) + (this.previous == null ? "" : TOSTRING_PREVIOUS_CONCAT);
        this.enString = this.asString(this, ENSTRING_SERIAL_NUM_PREFIX);
    }

    private String asString(SerialOid x, String serialNumPrefix) {
        return (x.isTransient() ? "T" : "") + "OID" + serialNumPrefix + Long.toString(x.serialNo, 16).toUpperCase();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((SerialOid)other);
    }

    public boolean equals(SerialOid other) {
        return other.serialNo == this.serialNo && other.state == this.state;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        PERSISTENT,
        TRANSIENT;


        public boolean isTransient() {
            return this == TRANSIENT;
        }
    }
}

