/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.services;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.services.RepositoryHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleRepository {
    private final Class<?> type;
    private NakedObjectSpecification spec;

    public SimpleRepository(Class<?> cls) {
        this.type = cls;
    }

    public String getId() {
        return "repository#" + this.getClass().getName();
    }

    public String iconName() {
        return this.getSpec().getShortName();
    }

    public String title() {
        return this.getSpec().getPluralName();
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("class", this.type.getName());
        return str.toString();
    }

    public Object[] allInstances() {
        return RepositoryHelper.allInstances(this.getSpec(), this.type);
    }

    public String disableAllInstances() {
        return this.hasInstances() ? null : "No " + this.getSpec().getPluralName();
    }

    public Object[] findByTitle(String title) {
        return RepositoryHelper.findByTitle(this.getSpec(), this.type, title).toArray();
    }

    public String disableFindByTitle() {
        return this.disableAllInstances();
    }

    public static String[] parameterNamesFindByTitle() {
        return new String[]{"Title to find"};
    }

    public static boolean[] parametersRequiredFindByTitle() {
        return new boolean[]{true};
    }

    private boolean hasInstances() {
        return RepositoryHelper.hasInstances(this.getSpec());
    }

    public Object newPersistentInstance() {
        NakedObject adapter = this.getPersistenceSession().createInstance(this.getSpec());
        this.getPersistenceSession().makePersistent(adapter);
        return adapter.getObject();
    }

    public Object newTransientInstance() {
        return this.getPersistenceSession().createInstance(this.getSpec()).getObject();
    }

    protected NakedObjectSpecification getSpec() {
        if (this.spec == null) {
            this.spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(this.type);
        }
        return this.spec;
    }

    public static boolean alwaysHideSpec() {
        return true;
    }

    private PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }
}

