/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.services.config;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.factory.InstanceCreationClassException;
import org.nakedobjects.metamodel.commons.factory.InstanceCreationException;
import org.nakedobjects.metamodel.commons.lang.ArrayUtils;
import org.nakedobjects.metamodel.commons.lang.ListUtils;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.installers.InstallerAbstract;
import org.nakedobjects.runtime.persistence.services.InitialisationException;
import org.nakedobjects.runtime.persistence.services.ServicesInstaller;
import org.nakedobjects.runtime.persistence.services.SimpleRepository;
import org.nakedobjects.runtime.system.DeploymentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesFromConfiguration
extends InstallerAbstract
implements ServicesInstaller {
    private static final char DELIMITER = '#';
    private static final Logger LOG = Logger.getLogger(ServicesFromConfiguration.class);
    private static final String SERVICES = "services";
    private static final String SERVICES_PREFIX = "services.prefix";

    public ServicesFromConfiguration() {
        super("services-installer", "configuration");
    }

    @Override
    public List<Object> getServices(DeploymentType deploymentType) {
        LOG.info((Object)("installing " + this.getClass().getName()));
        Object[] common = this.createServices(this.getConfiguration(), null);
        Object[] specific = this.createServices(this.getConfiguration(), deploymentType.name());
        Object[] combined = ArrayUtils.combine((Object[][])new Object[][]{common, specific});
        if (combined.length == 0) {
            throw new InitialisationException("No services specified");
        }
        return ListUtils.asList((Object[])combined);
    }

    private Object[] createServices(NakedObjectConfiguration configuration, String group) {
        String root = "nakedobjects." + (group == null ? "" : group.toLowerCase() + ".");
        String servicePrefix = configuration.getString(root + SERVICES_PREFIX);
        if (group != null && servicePrefix == null) {
            servicePrefix = configuration.getString("nakedobjects.services.prefix");
        }
        String prefix = ServicesFromConfiguration.servicePrefix(servicePrefix);
        String serviceList = configuration.getString(root + SERVICES);
        if (serviceList != null) {
            return this.createServices(prefix, serviceList);
        }
        return new Object[0];
    }

    private Object[] createServices(String servicePrefix, String serviceList) {
        StringTokenizer services = new StringTokenizer(serviceList, ",");
        if (!services.hasMoreTokens()) {
            throw new InitialisationException("Services specified, but none loaded");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        while (services.hasMoreTokens()) {
            String serviceName = services.nextToken().trim();
            if (serviceName.equals("")) continue;
            LOG.info((Object)("  creating service " + serviceName));
            Object service = serviceName.indexOf(35) == -1 ? this.createService(servicePrefix + serviceName) : this.createSimpleRepository(servicePrefix, serviceName);
            list.add(service);
        }
        Object[] array = list.toArray(new Object[list.size()]);
        return array;
    }

    private Object createSimpleRepository(String prefix, String name) {
        int pos = name.indexOf(35);
        String type = name.substring(0, pos);
        if (!"repository".equals(type)) {
            throw new InitialisationException(String.format("Unknown service type '%s'", type));
        }
        String className = prefix + name.substring(pos + 1);
        Class<?> underlying = ServicesFromConfiguration.loadClass(className);
        return new SimpleRepository(underlying);
    }

    private Object createService(String className) {
        Class<?> loadedClass = ServicesFromConfiguration.loadClass(className);
        return ServicesFromConfiguration.createInstance(loadedClass);
    }

    private static String servicePrefix(String servicePrefix) {
        String prefix;
        String string = prefix = servicePrefix == null ? "" : servicePrefix.trim();
        if (prefix.length() > 0 && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        return prefix;
    }

    private static Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new InitialisationException(String.format("Cannot find service class '%s'", className));
        }
    }

    private static <T> T createInstance(Class<T> serviceType) {
        try {
            return serviceType.newInstance();
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException("Class found '" + serviceType + "', but is missing a dependent class", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new InstanceCreationException("Could not instantiate an object of class '" + serviceType.getName() + "'; " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new InstanceCreationException("Could not access the class '" + serviceType.getName() + "'; " + e.getMessage());
        }
    }
}

