/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.session;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.lang.JavaClassUtils;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authorization.AuthorizationManager;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSession;
import org.nakedobjects.runtime.session.NakedObjectSessionDefault;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.userprofile.UserProfile;
import org.nakedobjects.runtime.userprofile.UserProfileLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NakedObjectSessionFactoryAbstract
implements NakedObjectSessionFactory {
    private final DeploymentType deploymentType;
    private final NakedObjectConfiguration configuration;
    private final TemplateImageLoader templateImageLoader;
    private final SpecificationLoader specificationLoader;
    private final AuthenticationManager authenticationManager;
    private final AuthorizationManager authorizationManager;
    private final PersistenceSessionFactory persistenceSessionFactory;
    private final UserProfileLoader userProfileLoader;
    private final List<Object> serviceList;

    public NakedObjectSessionFactoryAbstract(DeploymentType deploymentType, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, TemplateImageLoader templateImageLoader, AuthenticationManager authenticationManager, AuthorizationManager authorizationManager, UserProfileLoader userProfileLoader, PersistenceSessionFactory persistenceSessionFactory, List<Object> serviceList) {
        Ensure.ensureThatArg((Object)((Object)deploymentType), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)configuration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)specificationLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)templateImageLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)authenticationManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)authorizationManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)userProfileLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)persistenceSessionFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg(serviceList, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.deploymentType = deploymentType;
        this.configuration = configuration;
        this.templateImageLoader = templateImageLoader;
        this.specificationLoader = specificationLoader;
        this.authenticationManager = authenticationManager;
        this.authorizationManager = authorizationManager;
        this.userProfileLoader = userProfileLoader;
        this.persistenceSessionFactory = persistenceSessionFactory;
        this.serviceList = serviceList;
    }

    public void init() {
        this.templateImageLoader.init();
        this.specificationLoader.setServiceClasses(JavaClassUtils.toClasses(this.serviceList));
        this.specificationLoader.init();
        this.specificationLoader.injectInto((Object)this.persistenceSessionFactory);
        this.persistenceSessionFactory.setServices(this.serviceList);
        this.userProfileLoader.setServices(this.serviceList);
        this.authenticationManager.init();
        this.authorizationManager.init();
        this.persistenceSessionFactory.init();
    }

    public void shutdown() {
        this.persistenceSessionFactory.shutdown();
        this.authenticationManager.shutdown();
        this.specificationLoader.shutdown();
        this.templateImageLoader.shutdown();
        this.userProfileLoader.shutdown();
    }

    @Override
    public NakedObjectSession openSession(AuthenticationSession authenticationSession) {
        PersistenceSession persistenceSession = this.persistenceSessionFactory.createPersistenceSession();
        Ensure.ensureThatArg((Object)persistenceSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        UserProfile userProfile = this.userProfileLoader.getProfile(authenticationSession);
        Ensure.ensureThatArg((Object)userProfile, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.getSpecificationLoader().injectInto((Object)persistenceSession);
        NakedObjectSessionDefault nakedObjectSessionDefault = new NakedObjectSessionDefault(this, authenticationSession, persistenceSession, userProfile);
        return nakedObjectSessionDefault;
    }

    @Override
    public NakedObjectConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    @Override
    public TemplateImageLoader getTemplateImageLoader() {
        return this.templateImageLoader;
    }

    @Override
    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    @Override
    public PersistenceSessionFactory getPersistenceSessionFactory() {
        return this.persistenceSessionFactory;
    }

    @Override
    public UserProfileLoader getUserProfileLoader() {
        return this.userProfileLoader;
    }

    @Override
    public List<Object> getServices() {
        return this.serviceList;
    }
}

