/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system;

import java.util.List;
import org.nakedobjects.runtime.context.NakedObjectsContextStatic;
import org.nakedobjects.runtime.context.NakedObjectsContextThreadLocal;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContextCategory {
    STATIC_RELAXED{

        @Override
        public void initContext(NakedObjectSessionFactory sessionFactory) {
            NakedObjectsContextStatic.createRelaxedInstance(sessionFactory);
        }

        @Override
        public boolean canSpecifyViewers(List<String> viewers) {
            return viewers.size() <= 1;
        }
    }
    ,
    STATIC{

        @Override
        public void initContext(NakedObjectSessionFactory sessionFactory) {
            NakedObjectsContextStatic.createInstance(sessionFactory);
        }

        @Override
        public boolean canSpecifyViewers(List<String> viewers) {
            return viewers.size() == 1;
        }
    }
    ,
    THREADLOCAL{

        @Override
        public void initContext(NakedObjectSessionFactory sessionFactory) {
            NakedObjectsContextThreadLocal.createInstance(sessionFactory);
        }

        @Override
        public boolean canSpecifyViewers(List<String> viewers) {
            return true;
        }
    };


    public abstract void initContext(NakedObjectSessionFactory var1);

    public abstract boolean canSpecifyViewers(List<String> var1);
}

