/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system;

import java.util.List;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.system.ContextCategory;
import org.nakedobjects.runtime.system.DeploymentCategory;
import org.nakedobjects.runtime.system.Splash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DeploymentType {
    EXPLORATION(DeploymentCategory.EXPLORING, ContextCategory.STATIC_RELAXED, "dnd", Splash.SHOW),
    PROTOTYPE(DeploymentCategory.PROTOTYPING, ContextCategory.STATIC_RELAXED, "dnd", Splash.SHOW),
    CLIENT(DeploymentCategory.PRODUCTION, ContextCategory.STATIC, "dnd", Splash.SHOW),
    SERVER(DeploymentCategory.PRODUCTION, ContextCategory.THREADLOCAL, null, Splash.NO_SHOW),
    SERVER_EXPLORATION(DeploymentCategory.EXPLORING, ContextCategory.THREADLOCAL, null, Splash.NO_SHOW),
    SERVER_PROTOTYPE(DeploymentCategory.PROTOTYPING, ContextCategory.THREADLOCAL, null, Splash.NO_SHOW),
    SINGLE_USER(DeploymentCategory.PRODUCTION, ContextCategory.STATIC, "dnd", Splash.NO_SHOW),
    UTILITY(DeploymentCategory.EXPLORING, ContextCategory.STATIC, null, Splash.NO_SHOW);

    private final DeploymentCategory deploymentCategory;
    private final ContextCategory contextCategory;
    private final String defaultViewer;
    private final Splash splash;

    private DeploymentType(DeploymentCategory category, ContextCategory contextCategory, String defaultViewer, Splash splash) {
        this.deploymentCategory = category;
        this.contextCategory = contextCategory;
        this.defaultViewer = defaultViewer;
        this.splash = splash;
    }

    public void initContext(NakedObjectSessionFactory sessionFactory) {
        this.contextCategory.initContext(sessionFactory);
    }

    public boolean canSpecifyViewers(List<String> viewers) {
        return this.contextCategory.canSpecifyViewers(viewers);
    }

    public boolean canSpecifyConnectors(List<String> connectors) {
        return connectors.size() == 0 || this == CLIENT;
    }

    public boolean canSpecifyObjectStore() {
        return this != CLIENT;
    }

    public boolean canInstallFixtures() {
        return this != CLIENT;
    }

    public boolean shouldShowSplash() {
        return this.splash.isShow();
    }

    public boolean shouldMonitor() {
        return this == SERVER && this.isProduction();
    }

    public boolean isExploring() {
        return this.deploymentCategory == DeploymentCategory.EXPLORING;
    }

    public boolean isPrototyping() {
        return this.deploymentCategory == DeploymentCategory.PROTOTYPING;
    }

    public boolean isProduction() {
        return this.deploymentCategory == DeploymentCategory.PRODUCTION;
    }

    public String getDefaultViewer() {
        return this.defaultViewer;
    }

    public void addViewersIfAnyTo(List<String> requestedViewers) {
        if (requestedViewers.size() != 0) {
            return;
        }
        if (this.defaultViewer != null) {
            requestedViewers.add(this.defaultViewer);
        }
    }

    public static DeploymentType lookup(String str) {
        String underscoredStr = str.replace('-', '_').toUpperCase();
        return DeploymentType.valueOf(underscoredStr);
    }

    public String friendlyName() {
        return this.name().toLowerCase().replace('_', '-');
    }
}

