/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system.installers;

import java.util.List;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.FacetDecoratorInstaller;
import org.nakedobjects.metamodel.specloader.NakedObjectReflector;
import org.nakedobjects.metamodel.specloader.NakedObjectReflectorInstaller;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationManagerInstaller;
import org.nakedobjects.runtime.authorization.AuthorizationManager;
import org.nakedobjects.runtime.authorization.AuthorizationManagerInstaller;
import org.nakedobjects.runtime.fixturesinstaller.FixturesInstaller;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.imageloader.TemplateImageLoaderInstaller;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.persistence.PersistenceMechanismInstaller;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.internal.RuntimeContextFromSession;
import org.nakedobjects.runtime.persistence.services.ServicesInstaller;
import org.nakedobjects.runtime.remoting.ClientConnectionInstaller;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSessionFactoryDefault;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.NakedObjectSystemException;
import org.nakedobjects.runtime.system.NakedObjectsSystemAbstract;
import org.nakedobjects.runtime.transaction.facetdecorator.standard.TransactionFacetDecoratorInstaller;
import org.nakedobjects.runtime.userprofile.UserProfileLoader;
import org.nakedobjects.runtime.userprofile.UserProfileLoaderDefault;
import org.nakedobjects.runtime.userprofile.UserProfileStore;
import org.nakedobjects.runtime.userprofile.UserProfileStoreInstaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NakedObjectsSystemUsingInstallers
extends NakedObjectsSystemAbstract {
    public static final Logger LOG = Logger.getLogger(NakedObjectsSystemUsingInstallers.class);
    private final InstallerLookup installerLookup;
    private AuthenticationManagerInstaller authenticationInstaller;
    private AuthorizationManagerInstaller authorizationInstaller;
    private NakedObjectReflectorInstaller reflectorInstaller;
    private ServicesInstaller servicesInstaller;
    private UserProfileStoreInstaller userProfileStoreInstaller;
    private PersistenceMechanismInstaller persistenceMechanismInstaller;
    private FixturesInstaller fixtureInstaller;

    public NakedObjectsSystemUsingInstallers(DeploymentType deploymentType, InstallerLookup installerLookup) {
        super(deploymentType);
        Ensure.ensureThatArg((Object)installerLookup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.installerLookup = installerLookup;
    }

    public InstallerLookup getInstallerLookup() {
        return this.installerLookup;
    }

    @Override
    public NakedObjectSessionFactory doCreateSessionFactory(DeploymentType deploymentType) throws NakedObjectSystemException {
        PersistenceSessionFactory persistenceSessionFactory = this.obtainPersistenceSessionFactory(deploymentType);
        UserProfileLoaderDefault userProfileLoader = new UserProfileLoaderDefault(this.obtainUserProfileStore());
        return this.createSessionFactory(deploymentType, userProfileLoader, persistenceSessionFactory);
    }

    protected final NakedObjectSessionFactory createSessionFactory(DeploymentType deploymentType, UserProfileLoader userProfileLoader, PersistenceSessionFactory persistenceSessionFactory) throws NakedObjectSystemException {
        NakedObjectConfiguration configuration = this.getConfiguration();
        AuthenticationManager authenticationManager = this.obtainAuthenticationManager(deploymentType);
        AuthorizationManager authorizationManager = this.obtainAuthorizationManager(deploymentType);
        TemplateImageLoader templateImageLoader = this.obtainTemplateImageLoader();
        NakedObjectReflector reflector = this.obtainReflector(deploymentType);
        List<Object> servicesList = this.obtainServices();
        reflector.setRuntimeContext((RuntimeContext)new RuntimeContextFromSession());
        return new NakedObjectSessionFactoryDefault(deploymentType, configuration, templateImageLoader, (SpecificationLoader)reflector, authenticationManager, authorizationManager, userProfileLoader, persistenceSessionFactory, servicesList);
    }

    @Override
    public NakedObjectConfiguration getConfiguration() {
        return this.installerLookup.getConfiguration();
    }

    public void lookupAndSetAuthenticatorAndAuthorization(boolean isProduction) {
        NakedObjectConfiguration configuration = this.installerLookup.getConfiguration();
        String connection = configuration.getString("nakedobjects.connector");
        if (connection != null) {
            this.lookupAndSetAuthenticatorAndAuthorizationUsingClientConnectionInstaller(connection);
        } else {
            this.lookupAndSetAuthenticatorAndAuthorizationInstallers(isProduction);
        }
    }

    private void lookupAndSetAuthenticatorAndAuthorizationUsingClientConnectionInstaller(String connection) {
        ClientConnectionInstaller clientConnectionInstaller = this.installerLookup.clientConnectionInstaller(connection);
        if (clientConnectionInstaller == null) {
            return;
        }
        this.setAuthenticationInstaller(clientConnectionInstaller);
        this.setAuthorizationInstaller(clientConnectionInstaller);
    }

    private void lookupAndSetAuthenticatorAndAuthorizationInstallers(boolean isProduction) {
        AuthorizationManagerInstaller authorizationInstaller;
        AuthenticationManagerInstaller authenticationInstaller = this.installerLookup.authenticationManagerInstaller(null, isProduction);
        if (authenticationInstaller != null) {
            this.setAuthenticationInstaller(authenticationInstaller);
        }
        if ((authorizationInstaller = this.installerLookup.authorizationManagerInstaller(null, isProduction)) != null) {
            this.setAuthorizationInstaller(authorizationInstaller);
        }
    }

    public void setAuthenticationInstaller(AuthenticationManagerInstaller authenticationManagerInstaller) {
        this.authenticationInstaller = authenticationManagerInstaller;
    }

    public void setAuthorizationInstaller(AuthorizationManagerInstaller authorizationManagerInstaller) {
        this.authorizationInstaller = authorizationManagerInstaller;
    }

    @Override
    protected AuthenticationManager obtainAuthenticationManager(DeploymentType deploymentType) {
        return this.authenticationInstaller.createAuthenticationManager();
    }

    protected AuthorizationManager obtainAuthorizationManager(DeploymentType deploymentType) {
        return this.authorizationInstaller.createAuthorizationManager();
    }

    public void lookupAndSetFixturesInstaller() {
        NakedObjectConfiguration configuration = this.installerLookup.getConfiguration();
        String fixture = configuration.getString("nakedobjects.fixtures-installer");
        FixturesInstaller fixturesInstaller = this.installerLookup.fixturesInstaller(fixture);
        if (fixturesInstaller != null) {
            this.fixtureInstaller = fixturesInstaller;
        }
    }

    public void setFixtureInstaller(FixturesInstaller fixtureInstaller) {
        this.fixtureInstaller = fixtureInstaller;
    }

    @Override
    protected FixturesInstaller obtainFixturesInstaller() throws NakedObjectSystemException {
        return this.fixtureInstaller;
    }

    @Override
    protected TemplateImageLoader obtainTemplateImageLoader() {
        TemplateImageLoaderInstaller templateImageLoaderInstaller = this.installerLookup.templateImageLoaderInstaller(null);
        if (templateImageLoaderInstaller != null) {
            return templateImageLoaderInstaller.createLoader();
        }
        return super.obtainTemplateImageLoader();
    }

    public void setReflectorInstaller(NakedObjectReflectorInstaller reflectorInstaller) {
        this.reflectorInstaller = reflectorInstaller;
    }

    @Override
    protected NakedObjectReflector obtainReflector(DeploymentType deploymentType) throws NakedObjectSystemException {
        if (this.reflectorInstaller == null) {
            String fromCmdLine = this.getConfiguration().getString("nakedobjects.reflector");
            this.reflectorInstaller = this.installerLookup.reflectorInstaller(fromCmdLine);
        }
        Ensure.ensureThatState((Object)this.reflectorInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"reflector installer has not been injected and could not be looked up");
        this.reflectorInstaller.addFacetDecoratorInstaller((FacetDecoratorInstaller)this.installerLookup.getInstaller(TransactionFacetDecoratorInstaller.class));
        String connection = this.getConfiguration().getString("nakedobjects.connector");
        if (connection != null) {
            ClientConnectionInstaller clientConnectionInstaller = this.installerLookup.clientConnectionInstaller(connection);
            this.reflectorInstaller.addFacetDecoratorInstaller((FacetDecoratorInstaller)clientConnectionInstaller);
        }
        return this.reflectorInstaller.createReflector();
    }

    public void setServicesInstaller(ServicesInstaller servicesInstaller) {
        this.servicesInstaller = servicesInstaller;
    }

    @Override
    protected List<Object> obtainServices() {
        if (this.servicesInstaller == null) {
            this.servicesInstaller = this.installerLookup.servicesInstaller(null);
        }
        Ensure.ensureThatState((Object)this.servicesInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"services installer has not been injected and could not be looked up");
        return this.servicesInstaller.getServices(this.getDeploymentType());
    }

    public void lookupAndSetUserProfileFactoryInstaller() {
        NakedObjectConfiguration configuration = this.installerLookup.getConfiguration();
        String persistor = configuration.getString("nakedobjects.user-profile-store");
        UserProfileStoreInstaller userProfilePersistenceMechanismInstaller = this.installerLookup.userProfilePersistenceMechanismInstaller(persistor, this.getDeploymentType());
        if (userProfilePersistenceMechanismInstaller != null) {
            this.setUserProfileStoreInstaller(userProfilePersistenceMechanismInstaller);
        }
    }

    public void setUserProfileStoreInstaller(UserProfileStoreInstaller userProfilestoreInstaller) {
        this.userProfileStoreInstaller = userProfilestoreInstaller;
    }

    @Override
    protected UserProfileStore obtainUserProfileStore() {
        return this.userProfileStoreInstaller.createUserProfileStore(this.getConfiguration());
    }

    public void setPersistenceMechanismInstaller(PersistenceMechanismInstaller persistenceMechanismInstaller) {
        this.persistenceMechanismInstaller = persistenceMechanismInstaller;
    }

    @Override
    protected PersistenceSessionFactory obtainPersistenceSessionFactory(DeploymentType deploymentType) throws NakedObjectSystemException {
        String connection = this.getConfiguration().getString("nakedobjects.connector");
        if (connection != null) {
            this.persistenceMechanismInstaller = this.installerLookup.clientConnectionInstaller(connection);
        }
        if (this.persistenceMechanismInstaller == null) {
            String persistenceMechanism = this.getConfiguration().getString("nakedobjects.persistor");
            this.persistenceMechanismInstaller = this.installerLookup.persistenceMechanismInstaller(persistenceMechanism, deploymentType);
        }
        Ensure.ensureThatState((Object)this.persistenceMechanismInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persistor installer has not been injected and could not be looked up");
        return this.persistenceMechanismInstaller.createPersistenceSessionFactory(deploymentType);
    }
}

