/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system.internal.monitor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.services.InitialisationException;
import org.nakedobjects.runtime.system.NakedObjectsSystem;

public abstract class AbstractServerMonitor {
    private static final Logger LOG = Logger.getLogger(AbstractServerMonitor.class);
    private static final String ADDRESS = "nakedobjects.monitor.address";
    private boolean acceptConnection = true;

    public void listen() {
        String hostAddress = NakedObjectsContext.getConfiguration().getString(ADDRESS);
        try {
            InetAddress address = hostAddress == null ? null : InetAddress.getByName(hostAddress);
            int port = this.getPort();
            ServerSocket serverSocket = new ServerSocket(port, 2, address);
            serverSocket.setSoTimeout(5000);
            LOG.info((Object)("waiting for monitor connection on " + serverSocket));
            while (this.acceptConnection) {
                Socket client = null;
                try {
                    client = serverSocket.accept();
                    LOG.info((Object)("client connection on " + client));
                }
                catch (SocketTimeoutException ignore) {
                    continue;
                }
                catch (IOException e) {
                    LOG.error((Object)"request failed", (Throwable)e);
                    continue;
                }
                try {
                    this.handleRequest(client);
                }
                catch (Exception e) {
                    LOG.error((Object)"request failed", (Throwable)e);
                }
            }
        }
        catch (UnknownHostException e) {
            throw new InitialisationException(e);
        }
        catch (IOException e) {
            throw new InitialisationException(e);
        }
    }

    protected abstract int getPort();

    private void handleRequest(Socket socket) throws IOException {
        String request;
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        while (this.handleRequest(writer, request = reader.readLine())) {
        }
        writer.close();
        reader.close();
    }

    public abstract void setTarget(NakedObjectsSystem var1);

    public void shutdown() {
        this.acceptConnection = false;
    }

    protected abstract boolean handleRequest(PrintWriter var1, String var2) throws IOException;
}

