/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.transaction;

import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.runtime.transaction.NakedObjectTransaction;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

public abstract class NakedObjectTransactionAbstract
implements NakedObjectTransaction {
    private static final Logger LOG = Logger.getLogger(NakedObjectTransactionAbstract.class);
    private final NakedObjectTransactionManager transactionManager;
    private final MessageBroker messageBroker;
    private final UpdateNotifier updateNotifier;
    private NakedObjectTransaction.State state;
    private RuntimeException cause;

    public NakedObjectTransactionAbstract(NakedObjectTransactionManager transactionManager, MessageBroker messageBroker, UpdateNotifier updateNotifier) {
        Ensure.ensureThatArg((Object)transactionManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"transaction manager is required");
        Ensure.ensureThatArg((Object)messageBroker, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"message broker is required");
        Ensure.ensureThatArg((Object)updateNotifier, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"update notifier is required");
        this.transactionManager = transactionManager;
        this.messageBroker = messageBroker;
        this.updateNotifier = updateNotifier;
        this.state = NakedObjectTransaction.State.IN_PROGRESS;
    }

    public NakedObjectTransaction.State getState() {
        return this.state;
    }

    private void setState(NakedObjectTransaction.State state) {
        this.state = state;
    }

    public final void flush() {
        Ensure.ensureThatState((Object)this.getState().canFlush(), (Matcher)CoreMatchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("flush transaction " + this));
        }
        try {
            this.doFlush();
        }
        catch (RuntimeException ex) {
            this.setState(NakedObjectTransaction.State.MUST_ABORT);
            this.setAbortCause(ex);
            throw ex;
        }
    }

    public final void commit() {
        Ensure.ensureThatState((Object)this.getState().canCommit(), (Matcher)CoreMatchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("commit transaction " + this));
        }
        if (this.getState() == NakedObjectTransaction.State.COMMITTED) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"already committed; ignoring");
            }
            return;
        }
        try {
            this.doFlush();
            this.setState(NakedObjectTransaction.State.COMMITTED);
        }
        catch (RuntimeException ex) {
            this.setAbortCause(ex);
            throw ex;
        }
    }

    public final void abort() {
        Ensure.ensureThatState((Object)this.getState().canAbort(), (Matcher)CoreMatchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("abort transaction " + this));
        }
        try {
            this.doAbort();
        }
        catch (RuntimeException ex) {
            this.setAbortCause(ex);
            throw ex;
        }
        finally {
            this.setState(NakedObjectTransaction.State.ABORTED);
        }
    }

    protected abstract void doFlush();

    protected abstract void doAbort();

    protected void setAbortCause(RuntimeException cause) {
        this.cause = cause;
    }

    public RuntimeException getAbortCause() {
        return this.cause;
    }

    public String toString() {
        return this.appendTo(new ToString((Object)this)).toString();
    }

    protected ToString appendTo(ToString str) {
        str.append("state", (Object)this.state);
        return str;
    }

    public NakedObjectTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public MessageBroker getMessageBroker() {
        return this.messageBroker;
    }

    public UpdateNotifier getUpdateNotifier() {
        return this.updateNotifier;
    }
}

