/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.viewer;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.applib.fixtures.LogonFixture;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.config.ConfigurationBuilder;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestPassword;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.NakedObjectsSystem;
import org.nakedobjects.runtime.viewer.NakedObjectsViewer;
import org.nakedobjects.runtime.web.WebAppSpecification;

public abstract class NakedObjectsViewerAbstract
implements NakedObjectsViewer {
    private DeploymentType deploymentType;
    private InstallerLookup installerLookup;
    private ConfigurationBuilder configurationBuilder;
    private NakedObjectsSystem system;
    private AuthenticationRequest authenticationRequestViaArgs;

    public void init() {
        this.ensureDependenciesInjected();
        NakedObjectConfiguration configuration = this.configurationBuilder.getConfiguration();
        this.deploymentType = DeploymentType.lookup(configuration.getString("nakedobjects.deploymentType"));
        String user = configuration.getString("nakedobjects.user");
        String password = configuration.getString("nakedobjects.password");
        if (user != null) {
            this.authenticationRequestViaArgs = new AuthenticationRequestPassword(user, password);
        }
    }

    public void shutdown() {
    }

    public final DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public WebAppSpecification getWebAppSpecification() {
        return null;
    }

    public AuthenticationRequest getAuthenticationRequestViaArgs() {
        return this.authenticationRequestViaArgs;
    }

    protected void clearAuthenticationRequestViaArgs() {
        this.authenticationRequestViaArgs = null;
    }

    public LogonFixture getLogonFixture() {
        return this.system != null ? this.system.getLogonFixture() : null;
    }

    protected void ensureDependenciesInjected() {
        Ensure.ensureThatState((Object)this.installerLookup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState((Object)this.configurationBuilder, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    public void setInstallerLookup(InstallerLookup installerLookup) {
        this.installerLookup = installerLookup;
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        return this.configurationBuilder;
    }

    public void setConfigurationBuilder(ConfigurationBuilder configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
    }

    protected static NakedObjectConfiguration getConfiguration() {
        return NakedObjectsContext.getConfiguration();
    }

    public static AuthenticationManager getAuthenticationManager() {
        return NakedObjectsContext.getAuthenticationManager();
    }
}

