package org.nakedobjects.webserver.viewer.jetty;

import static org.nakedobjects.webserver.WebServerConstants.EMBEDDED_WEB_SERVER_PORT_DEFAULT;
import static org.nakedobjects.webserver.WebServerConstants.EMBEDDED_WEB_SERVER_PORT_KEY;

import java.util.HashMap;
import java.util.Map;

import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.CastUtils;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.system.SystemConstants;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerAbstract;

public class JettyViewer extends NakedObjectsViewerAbstract {

	private static final String CONTEXT_PATH = "/";

	public JettyViewer() {
		super(SystemBootstrapping.BOOTSTRAPS);
	}
	
	@Override
	public void init() {
		super.init();
		
		NakedObjectConfiguration configuration = getConfigurationBuilder().getConfiguration();
		
		// we don't bootstrap the system here; instead we expect it to be bootstrapped 
		// from the ServletContextInitializer in the web.xml
		int port = configuration.getInteger(EMBEDDED_WEB_SERVER_PORT_KEY, EMBEDDED_WEB_SERVER_PORT_DEFAULT);
		
		Server server = new Server(port);
		WebAppContext context = new WebAppContext("src/main/webapp", CONTEXT_PATH);
		
		copyDeploymentTypeIntoInitParams(context);
		
		server.setHandler(context);
		try {
			server.start();
			server.join(); 
		} catch (Exception ex) {
			throw new NakedObjectException("Unable to start Jetty server", ex);
		}
	}

	private void copyDeploymentTypeIntoInitParams(WebAppContext context) {
		Map<String,String> initParams = CastUtils.cast(context.getInitParams());
		initParams = new HashMap<String, String>(initParams);
		initParams.put(SystemConstants.DEPLOYMENT_TYPE_KEY, getDeploymentType().name());
		context.setInitParams(initParams);
	}

}
