/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.webserver.embedded.jetty;

import java.util.EventListener;
import java.util.List;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.servlet.SessionHandler;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.runtime.web.EmbeddedWebServerAbstract;
import org.nakedobjects.runtime.web.FilterSpecification;
import org.nakedobjects.runtime.web.ServletSpecification;
import org.nakedobjects.runtime.web.WebAppSpecification;
import org.nakedobjects.webapp.WebAppConstants;
import org.nakedobjects.webserver.WebServerException;

public class EmbeddedWebServerJetty
extends EmbeddedWebServerAbstract {
    private static final Logger LOG = Logger.getLogger(EmbeddedWebServerJetty.class);

    public void init() {
        super.init();
        HandlerList handlers = this.createHandlers();
        ContextHandler contextHandler = this.createContextHandler(handlers);
        this.startServer(contextHandler);
    }

    private HandlerList createHandlers() {
        HandlerList handlers = new HandlerList();
        this.addResourcesAndWelcomeFiles(handlers);
        ServletHandler servletHandler = new ServletHandler();
        this.addServletsAndFilters(servletHandler);
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setHandler((Handler)servletHandler);
        handlers.addHandler((Handler)sessionHandler);
        return handlers;
    }

    private void addResourcesAndWelcomeFiles(HandlerList handlers) {
        for (WebAppSpecification specification : this.getSpecifications()) {
            List files = specification.getWelcomeFiles();
            String[] welcomeFiles = files.toArray(new String[files.size()]);
            for (String resourcePath : specification.getResourcePaths()) {
                ResourceHandler resourceHandler = new ResourceHandler();
                resourceHandler.setResourceBase(resourcePath);
                resourceHandler.setWelcomeFiles(welcomeFiles);
                handlers.addHandler((Handler)resourceHandler);
            }
        }
    }

    private void addServletsAndFilters(ServletHandler servletHandler) {
        for (WebAppSpecification requirement : this.getSpecifications()) {
            this.addServletMappings(servletHandler, requirement);
            this.addFilterMappings(servletHandler, requirement);
        }
    }

    private void addServletMappings(ServletHandler servletHandler, WebAppSpecification webAppSpec) {
        for (ServletSpecification servletSpec : webAppSpec.getServletSpecifications()) {
            ServletHolder servletHolder = new ServletHolder(servletSpec.getServletClass());
            servletHolder.setInitParameters(servletSpec.getInitParams());
            servletHandler.addServlet(servletHolder);
            ServletMapping servletMapping = new ServletMapping();
            servletMapping.setServletName(servletHolder.getName());
            servletMapping.setPathSpecs(servletSpec.getPathSpecs().toArray(new String[0]));
            servletHandler.addServletMapping(servletMapping);
        }
    }

    private void addFilterMappings(ServletHandler servletHandler, WebAppSpecification webAppSpec) {
        for (FilterSpecification filterSpec : webAppSpec.getFilterSpecifications()) {
            FilterHolder filterHolder = new FilterHolder(filterSpec.getFilterClass());
            filterHolder.setInitParameters(filterSpec.getInitParams());
            servletHandler.addFilter(filterHolder);
            FilterMapping filterMapping = new FilterMapping();
            filterMapping.setFilterName(filterHolder.getName());
            filterMapping.setPathSpecs(filterSpec.getPathSpecs().toArray(new String[0]));
            filterMapping.setDispatches(0);
            servletHandler.addFilterMapping(filterMapping);
        }
    }

    private ContextHandler createContextHandler(HandlerList handlers) {
        ContextHandler contextHandler = this.buildContextHandler(handlers);
        this.addContextParams(contextHandler);
        this.addServletContextListeners(contextHandler);
        this.setWelcomeFiles(contextHandler);
        this.bindSystemIfAvailable(contextHandler);
        return contextHandler;
    }

    private ContextHandler buildContextHandler(HandlerList handlers) {
        ContextHandler contextHandler = new ContextHandler("/");
        contextHandler.setClassLoader(Thread.currentThread().getContextClassLoader());
        contextHandler.setHandler((Handler)handlers);
        return contextHandler;
    }

    private void addContextParams(ContextHandler contextHandler) {
        for (WebAppSpecification specification : this.getSpecifications()) {
            contextHandler.setInitParams(specification.getContextParams());
        }
    }

    private void addServletContextListeners(ContextHandler contextHandler) {
        for (WebAppSpecification specification : this.getSpecifications()) {
            for (Class servletContextListenerClass : specification.getServletContextListeners()) {
                ServletContextListener servletContext = (ServletContextListener)InstanceFactory.createInstance((Class)servletContextListenerClass);
                contextHandler.addEventListener((EventListener)servletContext);
            }
        }
    }

    private void setWelcomeFiles(ContextHandler contextHandler) {
        for (WebAppSpecification specification : this.getSpecifications()) {
            contextHandler.setWelcomeFiles(specification.getWelcomeFiles().toArray(new String[0]));
        }
    }

    private void bindSystemIfAvailable(ContextHandler contextHandler) {
        if (this.getSystem() != null) {
            contextHandler.setAttribute(WebAppConstants.NAKED_OBJECTS_SYSTEM_KEY, (Object)this.getSystem());
        }
    }

    private void startServer(ContextHandler contextHandler) {
        int port = EmbeddedWebServerJetty.getConfiguration().getInteger("nakedobjects.webserver.port", 8080);
        LOG.info((Object)("Starting web server: open a web browser and use URL http://localhost:" + port + "/logon.app to connect"));
        try {
            Server server = new Server(port);
            server.addHandler((Handler)contextHandler);
            server.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebServerException("Web server failed to start", e);
        }
    }

    public void shutdown() {
    }
}

