/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.webserver.viewer.jetty;

import java.util.HashMap;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.CastUtils;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerAbstract;

public class JettyViewer
extends NakedObjectsViewerAbstract {
    private static final String CONTEXT_PATH = "/";

    public JettyViewer() {
        super(NakedObjectsViewerAbstract.SystemBootstrapping.BOOTSTRAPS);
    }

    public void init() {
        super.init();
        NakedObjectConfiguration configuration = this.getConfigurationBuilder().getConfiguration();
        int port = configuration.getInteger("nakedobjects.webserver.port", 8080);
        Server server = new Server(port);
        WebAppContext context = new WebAppContext("src/main/webapp", CONTEXT_PATH);
        this.copyDeploymentTypeIntoInitParams(context);
        server.setHandler((Handler)context);
        try {
            server.start();
            server.join();
        }
        catch (Exception ex) {
            throw new NakedObjectException("Unable to start Jetty server", (Throwable)ex);
        }
    }

    private void copyDeploymentTypeIntoInitParams(WebAppContext context) {
        HashMap<String, String> initParams = (HashMap<String, String>)CastUtils.cast((Object)context.getInitParams());
        initParams = new HashMap<String, String>(initParams);
        initParams.put("nakedobjects.deploymentType", this.getDeploymentType().name());
        context.setInitParams(initParams);
    }
}

