/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.webserver.viewer;

import java.util.HashMap;
import java.util.List;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.CastUtils;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.options.OptionHandler;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyViewer
extends NakedObjectsViewerAbstract {
    private List<OptionHandler> flagHandlers;

    public void init() {
        super.init();
        NakedObjectConfiguration configuration = this.getConfigurationBuilder().getConfiguration();
        int port = configuration.getInteger("nakedobjects.embedded-web-server.port", 8080);
        String webappContextPath = configuration.getString("nakedobjects.embedded-web-server.webapp", "");
        Server server = new Server(port);
        WebAppContext context = new WebAppContext("src/main/webapp", webappContextPath);
        this.copyConfigurationPrimersIntoServletContext(context);
        server.setHandler((Handler)context);
        try {
            server.start();
            server.join();
        }
        catch (Exception ex) {
            throw new NakedObjectException("Unable to start Jetty server", (Throwable)ex);
        }
    }

    private void copyConfigurationPrimersIntoServletContext(WebAppContext context) {
        List<OptionHandler> configurationPrimers = this.flagHandlers;
        context.setAttribute("nakedobjects.configurationPrimers", configurationPrimers);
    }

    private void copyDeploymentTypeIntoInitParams(WebAppContext context) {
        HashMap<String, String> initParams = (HashMap<String, String>)CastUtils.cast((Object)context.getInitParams());
        initParams = new HashMap<String, String>(initParams);
        initParams.put("nakedobjects.deploymentType", this.getDeploymentType().name());
        context.setInitParams(initParams);
    }

    public void setFlagHandlers(List<OptionHandler> flagHandlers) {
        this.flagHandlers = flagHandlers;
    }
}

