/*
 * Decompiled with CFR 0.152.
 */
package org.nameapi.ontology5.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.nameapi.ontology5.json.TypeRef;

public class JacksonJson {
    private final ObjectMapper mapper;

    public JacksonJson() {
        this(JacksonJson.mapper());
    }

    public JacksonJson(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @NotNull
    private static ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        GuavaModule module = new GuavaModule();
        mapper.registerModule((Module)module);
        return mapper;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public String serialize(Object obj) throws JsonProcessingException {
        if (obj != null) {
            return this.mapper.writeValueAsString(obj);
        }
        return null;
    }

    public <T> T deserialize(String body, TypeRef returnType) throws IOException {
        JavaType javaType = this.mapper.constructType(returnType.getType());
        try {
            return (T)this.mapper.readValue(body, javaType);
        }
        catch (IOException e) {
            if (returnType.getType().equals(String.class)) {
                return (T)body;
            }
            throw e;
        }
    }
}

