/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.deployer;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.nanocontainer.deployer.FolderContentHandler;
import org.picocontainer.Startable;

public class FolderContentPoller
implements Startable {
    private FolderContentHandler folderContentHandler;
    private FileObject folder;
    private Runnable poller = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    FolderContentPoller.this.folder.close();
                    FileObject[] currentChildren = FolderContentPoller.this.folder.getChildren();
                    FolderContentPoller.this.folderContentHandler.setCurrentChildren(currentChildren);
                    FolderContentPoller folderContentPoller = FolderContentPoller.this;
                    synchronized (folderContentPoller) {
                        FolderContentPoller.this.notify();
                        FolderContentPoller.this.wait(2000L);
                    }
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    FolderContentPoller.this.thread.interrupt();
                }
            }
        }
    };
    private Thread thread;
    private boolean started = false;

    public FolderContentPoller(FolderContentHandler folderChangeNotifier) {
        this.folderContentHandler = folderChangeNotifier;
        this.folder = folderChangeNotifier.getFolder();
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.thread = new Thread(this.poller);
        this.thread.start();
        this.started = true;
    }

    public void stop() {
        if (!this.started) {
            throw new IllegalStateException("Already stopped");
        }
        this.thread.interrupt();
        this.started = true;
    }
}

