/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.webcontainer.groovy;

import groovy.util.NodeBuilder;
import java.util.Map;
import javax.servlet.Servlet;
import org.nanocontainer.webcontainer.PicoContextHandler;
import org.nanocontainer.webcontainer.PicoFilterHolder;
import org.nanocontainer.webcontainer.PicoServletHolder;
import org.nanocontainer.webcontainer.groovy.FilterHolderBuilder;
import org.nanocontainer.webcontainer.groovy.ServletHolderBuilder;
import org.nanocontainer.webcontainer.groovy.adapters.WaffleAdapter;
import org.picocontainer.MutablePicoContainer;

public class ContextBuilder
extends NodeBuilder {
    private final MutablePicoContainer parentContainer;
    private final PicoContextHandler context;

    public ContextBuilder(MutablePicoContainer parentContainer, PicoContextHandler context) {
        this.parentContainer = parentContainer;
        this.context = context;
    }

    protected Object createNode(Object name, Map map) {
        if (name.equals("filter")) {
            return this.makeFilter(map);
        }
        if (name.equals("servlet")) {
            return this.makeServlet(map);
        }
        if (name.equals("listener")) {
            return this.makeListener(map);
        }
        if (name.equals("staticContent")) {
            this.setStaticContent(map);
            return null;
        }
        if (name.equals("waffleApp")) {
            return new WaffleAdapter(this.context, this.parentContainer, map).getNodeBuilder();
        }
        return null;
    }

    private void setStaticContent(Map map) {
        if (map.containsKey("welcomePage")) {
            this.context.setStaticContext((String)map.remove("path"), (String)map.remove("welcomePage"));
        } else {
            this.context.setStaticContext((String)map.remove("path"));
        }
    }

    private Object makeListener(Map map) {
        return this.context.addListener((Class)map.remove("class"));
    }

    private Object makeServlet(Map map) {
        if (map.containsKey("class")) {
            PicoServletHolder servlet = this.context.addServletWithMapping((Class)map.remove("class"), (String)map.remove("path"));
            return new ServletHolderBuilder(servlet);
        }
        Servlet servlet = (Servlet)map.remove("instance");
        this.context.addServletWithMapping(servlet, (String)map.remove("path"));
        return servlet;
    }

    private Object makeFilter(Map map) {
        PicoFilterHolder filter = this.context.addFilterWithMapping((Class)map.remove("class"), (String)map.remove("path"), this.extractDispatchers(map));
        FilterHolderBuilder builder = new FilterHolderBuilder(filter);
        return builder;
    }

    private int extractDispatchers(Map map) {
        Object dispatchers = map.remove("dispatchers");
        if (dispatchers != null) {
            return (Integer)dispatchers;
        }
        return 0;
    }
}

