/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.nanocontainer.script.ScriptBuilderResolver;
import org.nanocontainer.script.UnsupportedScriptTypeException;

public class ScriptBuilderResolverTestCase
extends TestCase {
    private ScriptBuilderResolver scriptBuilderResolver = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.scriptBuilderResolver = new ScriptBuilderResolver();
    }

    protected void tearDown() throws Exception {
        this.scriptBuilderResolver = null;
        super.tearDown();
    }

    public void testGetAllSupportedExtensions() {
        TreeSet<String> allExtensions = new TreeSet<String>();
        allExtensions.add(".xml");
        String[] actualReturn = this.scriptBuilderResolver.getAllSupportedExtensions();
        ScriptBuilderResolverTestCase.assertNotNull((Object)actualReturn);
        List<String> returnAsList = Arrays.asList(actualReturn);
        boolean someMerged = allExtensions.removeAll(returnAsList);
        ScriptBuilderResolverTestCase.assertTrue((boolean)someMerged);
        ScriptBuilderResolverTestCase.assertTrue((allExtensions.size() == 0 ? 1 : 0) != 0);
    }

    public void testGetBuilderClassNameForFile() {
        File compositionFile = new File("test.xml");
        String expected = "org.nanocontainer.script.xml.XMLContainerBuilder";
        String actual = this.scriptBuilderResolver.getBuilderClassName(compositionFile);
        ScriptBuilderResolverTestCase.assertEquals((String)"return value", (String)expected, (String)actual);
    }

    public void testGetBuilderClassNameForResource() {
        String resourceName = "/org/nanocontainer/nanocontainer.xml";
        URL compositionURL = ((Object)((Object)this)).getClass().getResource("/org/nanocontainer/nanocontainer.xml");
        if (compositionURL == null) {
            ScriptBuilderResolverTestCase.fail((String)"This test depended on resource '/org/nanocontainer/nanocontainer.xml' which appears to have been moved");
        }
        String expected = "org.nanocontainer.script.xml.XMLContainerBuilder";
        String actual = this.scriptBuilderResolver.getBuilderClassName(compositionURL);
        ScriptBuilderResolverTestCase.assertEquals((String)"return value", (String)expected, (String)actual);
    }

    public void testGetBuilderClassNameForExtension() throws UnsupportedScriptTypeException {
        String expectedReturn = "org.nanocontainer.script.xml.XMLContainerBuilder";
        String actualReturn = this.scriptBuilderResolver.getBuilderClassName(".xml");
        ScriptBuilderResolverTestCase.assertEquals((String)"return value", (String)expectedReturn, (String)actualReturn);
    }

    public void testGetBuilderForExtensionThrowsExceptionForUnknownBuilderType() {
        try {
            this.scriptBuilderResolver.getBuilderClassName(".foo");
            ScriptBuilderResolverTestCase.fail((String)"Retrieving extension of type .foo should have thrown exception");
        }
        catch (UnsupportedScriptTypeException ex) {
            ScriptBuilderResolverTestCase.assertEquals((String)".foo", (String)ex.getRequestedExtension());
        }
    }

    public void testRegisterBuilder() {
        this.scriptBuilderResolver.registerBuilder(".foo", "org.example.FooBar");
        ScriptBuilderResolverTestCase.assertEquals((String)"org.example.FooBar", (String)this.scriptBuilderResolver.getBuilderClassName(".foo"));
    }

    public void testResetBuilders() {
        this.scriptBuilderResolver.registerBuilder(".foo", "org.example.FooBar");
        this.scriptBuilderResolver.resetBuilders();
        try {
            this.scriptBuilderResolver.getBuilderClassName(".foo");
            ScriptBuilderResolverTestCase.fail((String)"Retrieving extension of type .foo should have thrown exception");
        }
        catch (UnsupportedScriptTypeException ex) {
            ScriptBuilderResolverTestCase.assertEquals((String)".foo", (String)ex.getRequestedExtension());
        }
    }
}

