/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.jruby;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.jruby.IRuby;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.nanocontainer.integrationkit.PicoCompositionException;
import org.nanocontainer.reflection.DefaultNanoPicoContainer;
import org.nanocontainer.script.NanoContainerMarkupException;
import org.nanocontainer.script.ScriptedContainerBuilder;
import org.picocontainer.PicoContainer;
import org.picocontainer.alternatives.EmptyPicoContainer;

public class JRubyContainerBuilder
extends ScriptedContainerBuilder {
    public static final String MARKUP_EXCEPTION_PREFIX = "nanobuilder: ";
    private String script;

    public JRubyContainerBuilder(Reader script, ClassLoader classLoader) {
        super(script, classLoader);
        this.script = this.toString(script);
    }

    private String toString(Reader script) {
        char[] chars = new char[1024];
        StringWriter writer = new StringWriter();
        try {
            int charsRead;
            while ((charsRead = script.read(chars)) != -1) {
                writer.write(chars, 0, charsRead);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("unable to read script from reader", e);
        }
        return writer.toString();
    }

    protected PicoContainer createContainerFromScript(PicoContainer parentContainer, Object assemblyScope) {
        if (parentContainer == null) {
            parentContainer = new EmptyPicoContainer();
        }
        parentContainer = new DefaultNanoPicoContainer(this.getClassLoader(), parentContainer);
        IRuby ruby = JavaEmbedUtils.initialize((List)Collections.EMPTY_LIST);
        ruby.getLoadService().require("org/nanocontainer/script/jruby/nanobuilder");
        ruby.defineReadonlyVariable("$parent", JavaEmbedUtils.javaToRuby((IRuby)ruby, (Object)parentContainer));
        ruby.defineReadonlyVariable("$assembly_scope", JavaEmbedUtils.javaToRuby((IRuby)ruby, (Object)assemblyScope));
        try {
            IRubyObject result = ruby.evalScript(this.script);
            return (PicoContainer)JavaEmbedUtils.rubyToJava((IRuby)ruby, (IRubyObject)result, (Class)PicoContainer.class);
        }
        catch (RaiseException re) {
            if (re.getCause() instanceof NanoContainerMarkupException) {
                throw (NanoContainerMarkupException)re.getCause();
            }
            String message = (String)JavaEmbedUtils.rubyToJava((IRuby)ruby, (IRubyObject)re.getException().message, (Class)String.class);
            if (message.startsWith(MARKUP_EXCEPTION_PREFIX)) {
                throw new NanoContainerMarkupException(message.substring(MARKUP_EXCEPTION_PREFIX.length()));
            }
            throw new PicoCompositionException(message, (Throwable)re);
        }
    }
}

